/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql.parser;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.Node;

public abstract class SimpleNode
implements Node,
Serializable,
EJBQLExpression {
    final int id;
    SimpleNode parent;
    SimpleNode[] children;
    boolean not;
    String text;

    public SimpleNode(int id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public boolean isNegated() {
        return this.not;
    }

    public void visit(EJBQLExpressionVisitor visitor) {
        if (this.visitNode(visitor)) {
            int len = this.getChildrenCount();
            for (int i = 0; i < len && this.visitChild(visitor, i); ++i) {
            }
        }
    }

    protected boolean visitNode(EJBQLExpressionVisitor visitor) {
        return true;
    }

    protected boolean visitChild(EJBQLExpressionVisitor visitor, int childIndex) {
        this.children[childIndex].visit(visitor);
        return true;
    }

    public EJBQLExpression getChild(int index) {
        return this.jjtGetChild(index);
    }

    public int getChildrenCount() {
        return this.jjtGetNumChildren();
    }

    public void replaceChild(SimpleNode oldChild, SimpleNode newChild) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != oldChild) continue;
            this.children[i] = newChild;
        }
    }

    public SimpleNode getParent() {
        return this.parent;
    }

    public String getName() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf("EJBQL");
        return i >= 0 ? className.substring(i + 5) : className;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node parent) {
        this.parent = (SimpleNode)parent;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new SimpleNode[i + 1];
        } else if (i >= this.children.length) {
            SimpleNode[] c = new SimpleNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = (SimpleNode)n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        this.dump(pw, "", true);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }

    void dump(PrintWriter out, String prefix, boolean text) {
        out.println(prefix + this.getName() + (text && this.text != null ? " [" + this.text + "]" : ""));
        if (this.children != null) {
            for (SimpleNode n : this.children) {
                if (n == null) continue;
                n.dump(out, prefix + " ", text);
            }
        }
    }
}

