/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.hsqldb.HSQLActionBuilder;
import org.apache.cayenne.dba.hsqldb.HSQLMergerFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBAdapter
extends JdbcAdapter {
    protected String getTableName(DbEntity entity) {
        QuotingStrategy context = this.getQuotingStrategy(entity.getDataMap().isQuotingSQLIdentifiers());
        return context.quoteFullyQualifiedName(entity);
    }

    protected String getSchemaName(DbEntity entity) {
        if (entity.getSchema() != null && entity.getSchema().length() > 0) {
            QuotingStrategy context = this.getQuotingStrategy(entity.getDataMap().isQuotingSQLIdentifiers());
            return context.quoteString(entity.getSchema()) + ".";
        }
        return "";
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new HSQLActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        boolean status = source.getDataMap() != null && source.getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.", new Object[0]);
        }
        String srcName = this.getTableName(source);
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ").append(context.quoteString(srcName));
        buf.append(" ADD CONSTRAINT ");
        buf.append(context.quoteString(this.getSchemaName(source)));
        String name = "U_" + source.getName() + "_" + (long)((double)System.currentTimeMillis() / (Math.random() * 100000.0));
        buf.append(context.quoteString(name));
        buf.append(" UNIQUE (");
        Iterator<DbAttribute> it = columns.iterator();
        DbAttribute first = it.next();
        buf.append(context.quoteString(first.getName()));
        while (it.hasNext()) {
            DbAttribute next = it.next();
            buf.append(", ");
            buf.append(context.quoteString(next.getName()));
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        boolean status = rel.getSourceEntity().getDataMap() != null && rel.getSourceEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        StringBuilder buf = new StringBuilder();
        StringBuilder refBuf = new StringBuilder();
        String srcName = this.getTableName((DbEntity)rel.getSourceEntity());
        String dstName = this.getTableName((DbEntity)rel.getTargetEntity());
        buf.append("ALTER TABLE ");
        buf.append(srcName);
        buf.append(" ADD CONSTRAINT ");
        buf.append(this.getSchemaName((DbEntity)rel.getSourceEntity()));
        String name = "U_" + rel.getSourceEntity().getName() + "_" + (long)((double)System.currentTimeMillis() / (Math.random() * 100000.0));
        buf.append(context.quoteString(name));
        buf.append(" FOREIGN KEY (");
        boolean first = true;
        for (DbJoin join : rel.getJoins()) {
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(context.quoteString(join.getSourceName()));
            refBuf.append(context.quoteString(join.getTargetName()));
        }
        buf.append(") REFERENCES ");
        buf.append(dstName);
        buf.append(" (");
        buf.append(refBuf.toString());
        buf.append(')');
        buf.append(" ON DELETE CASCADE");
        return buf.toString();
    }

    @Override
    public String createTable(DbEntity ent) {
        String sql = super.createTable(ent);
        if (sql != null && sql.toUpperCase().startsWith("CREATE TABLE ")) {
            sql = "CREATE CACHED TABLE " + sql.substring("CREATE TABLE ".length());
        }
        return sql;
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        if (column.getType() == 8 && column.getMaxLength() > 0) {
            int len = column.getMaxLength();
            column.setMaxLength(0);
            super.createTableAppendColumn(sqlBuffer, column);
            column.setMaxLength(len);
        } else {
            super.createTableAppendColumn(sqlBuffer, column);
        }
    }

    @Override
    public MergerFactory mergerFactory() {
        return new HSQLMergerFactory();
    }
}

