/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.DefaultBinder;
import org.apache.cayenne.di.spi.DefaultScope;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InjectionStack;
import org.apache.cayenne.di.spi.InstanceProvider;
import org.apache.cayenne.di.spi.NoScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInjector
implements Injector {
    private DefaultScope singletonScope = new DefaultScope(new Class[0]);
    private Scope noScope = NoScope.INSTANCE;
    private Map<Key<?>, Binding<?>> bindings;
    private InjectionStack injectionStack;
    private Scope defaultScope = this.singletonScope;

    public DefaultInjector(Module ... modules) throws ConfigurationException {
        this.bindings = new HashMap();
        this.injectionStack = new InjectionStack();
        DefaultBinder binder = new DefaultBinder(this);
        binder.bind(Injector.class).toInstance(this);
        if (modules != null && modules.length > 0) {
            for (Module module : modules) {
                module.configure(binder);
            }
        }
    }

    InjectionStack getInjectionStack() {
        return this.injectionStack;
    }

    <T> Binding<T> getBinding(Key<T> key) throws ConfigurationException {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        return this.bindings.get(key);
    }

    <T> void putBinding(Key<T> bindingKey, Provider<T> provider) {
        this.bindings.put(bindingKey, new Binding<T>(provider, this.defaultScope));
    }

    <T> void changeBindingScope(Key<T> bindingKey, Scope scope) {
        Binding<?> binding;
        if (scope == null) {
            scope = this.noScope;
        }
        if ((binding = this.bindings.get(bindingKey)) == null) {
            throw new ConfigurationException("No existing binding for key " + bindingKey, new Object[0]);
        }
        binding.changeScope(scope);
    }

    @Override
    public <T> T getInstance(Class<T> type) throws ConfigurationException {
        return this.getProvider(type).get();
    }

    @Override
    public <T> T getInstance(Key<T> key) throws ConfigurationException {
        return this.getProvider(key).get();
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) throws ConfigurationException {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) throws ConfigurationException {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        Binding<?> binding = this.bindings.get(key);
        if (binding == null) {
            throw new ConfigurationException("DI container has no binding for key %s", key);
        }
        return binding.getScoped();
    }

    @Override
    public void injectMembers(Object object) {
        InstanceProvider<Object> provider0 = new InstanceProvider<Object>(object);
        FieldInjectingProvider<Object> provider1 = new FieldInjectingProvider<Object>(provider0, this);
        provider1.get();
    }

    @Override
    public void shutdown() {
        this.singletonScope.shutdown();
    }

    DefaultScope getSingletonScope() {
        return this.singletonScope;
    }

    Scope getNoScope() {
        return this.noScope;
    }
}

