/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.io.Serializable;
import java.util.Collection;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventSubject;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGroupsBridge
extends EventBridge
implements MessageListener {
    protected byte[] state;
    protected Channel channel;
    protected PullPushAdapter adapter;
    protected String multicastAddress;
    protected String multicastPort;
    protected String configURL;

    public JavaGroupsBridge(EventSubject localSubject, String externalSubject) {
        super(localSubject, externalSubject);
    }

    public JavaGroupsBridge(Collection<EventSubject> localSubjects, String externalSubject) {
        super(localSubjects, externalSubject);
    }

    public String getConfigURL() {
        return this.configURL;
    }

    public void setConfigURL(String configURL) {
        this.configURL = configURL;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(String multicastAddress) {
        this.multicastAddress = multicastAddress;
    }

    public String getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(String multicastPort) {
        this.multicastPort = multicastPort;
    }

    public byte[] getState() {
        return this.state;
    }

    public void setState(byte[] state) {
        this.state = state;
    }

    public void receive(Message message) {
        try {
            CayenneEvent event = this.messageObjectToEvent((Serializable)message.getObject());
            if (event != null) {
                this.onExternalEvent(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void startupExternal() throws Exception {
        if (this.configURL != null) {
            this.channel = new JChannel(this.configURL);
        } else {
            String configString = this.buildConfigString();
            this.channel = new JChannel(configString);
        }
        this.channel.setOpt(3, (Object)Boolean.FALSE);
        this.channel.connect(this.externalSubject);
        if (this.receivesExternalEvents()) {
            this.adapter = new PullPushAdapter((Transport)this.channel, (MessageListener)this);
        }
    }

    protected String buildConfigString() {
        if (this.multicastAddress == null) {
            throw new IllegalStateException("'multcastAddress' is not set");
        }
        if (this.multicastPort == null) {
            throw new IllegalStateException("'multcastPort' is not set");
        }
        return "UDP(mcast_addr=" + this.multicastAddress + ";mcast_port=" + this.multicastPort + ";ip_ttl=32):" + "PING(timeout=3000;num_initial_members=6):" + "FD(timeout=3000):" + "VERIFY_SUSPECT(timeout=1500):" + "pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):" + "pbcast.STABLE(desired_avg_gossip=10000):" + "FRAG:" + "pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;" + "shun=true;print_local_addr=false)";
    }

    @Override
    protected void shutdownExternal() throws Exception {
        try {
            if (this.adapter != null) {
                this.adapter.stop();
            }
            this.channel.close();
        }
        finally {
            this.adapter = null;
            this.channel = null;
        }
    }

    @Override
    protected void sendExternalEvent(CayenneEvent localEvent) throws Exception {
        Message message = new Message(null, null, this.eventToMessageObject(localEvent));
        this.channel.send(message);
    }

    protected Serializable eventToMessageObject(CayenneEvent event) throws Exception {
        return event;
    }

    protected CayenneEvent messageObjectToEvent(Serializable object) throws Exception {
        return object instanceof CayenneEvent ? (CayenneEvent)object : null;
    }
}

