/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMap
implements Serializable,
XMLSerializable,
MappingNamespace,
DbEntityListener,
ObjEntityListener {
    public static final String CLIENT_SUPPORTED_PROPERTY = "clientSupported";
    public static final String DEFAULT_CLIENT_PACKAGE_PROPERTY = "defaultClientPackage";
    public static final String DEFAULT_CLIENT_SUPERCLASS_PROPERTY = "defaultClientSuperclass";
    public static final String DEFAULT_SCHEMA_PROPERTY = "defaultSchema";
    public static final String DEFAULT_PACKAGE_PROPERTY = "defaultPackage";
    public static final String DEFAULT_SUPERCLASS_PROPERTY = "defaultSuperclass";
    public static final String DEFAULT_LOCK_TYPE_PROPERTY = "defaultLockType";
    public static final String DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY = "quoteSqlIdentifiers";
    public static final String SCHEMA_XSD = "http://cayenne.apache.org/schema/3.0/modelMap";
    protected String name;
    protected String location;
    protected MappingNamespace namespace;
    protected Boolean quotingSQLIdentifiers;
    protected String defaultSchema;
    protected String defaultPackage;
    protected String defaultSuperclass;
    protected int defaultLockType;
    protected boolean clientSupported;
    protected String defaultClientPackage;
    protected String defaultClientSuperclass;
    private SortedMap<String, Embeddable> embeddablesMap = new TreeMap<String, Embeddable>();
    private SortedMap<String, ObjEntity> objEntityMap = new TreeMap<String, ObjEntity>();
    private SortedMap<String, DbEntity> dbEntityMap = new TreeMap<String, DbEntity>();
    private SortedMap<String, Procedure> procedureMap = new TreeMap<String, Procedure>();
    private SortedMap<String, Query> queryMap = new TreeMap<String, Query>();
    private SortedMap<String, SQLResult> results;
    private List<EntityListener> defaultEntityListeners = new ArrayList<EntityListener>(3);

    public boolean isQuotingSQLIdentifiers() {
        return this.quotingSQLIdentifiers;
    }

    public void setQuotingSQLIdentifiers(boolean quotingSqlIdentifiers) {
        this.quotingSQLIdentifiers = quotingSqlIdentifiers;
    }

    public DataMap() {
        this(null);
    }

    public DataMap(String mapName) {
        this(mapName, Collections.EMPTY_MAP);
    }

    public DataMap(String mapName, Map<String, Object> properties) {
        this.results = new TreeMap<String, SQLResult>();
        this.setName(mapName);
        this.initWithProperties(properties);
    }

    public void initWithProperties(Map<String, Object> properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        Object lockType = properties.get(DEFAULT_LOCK_TYPE_PROPERTY);
        Object packageName = properties.get(DEFAULT_PACKAGE_PROPERTY);
        Object schema = properties.get(DEFAULT_SCHEMA_PROPERTY);
        Object superclass = properties.get(DEFAULT_SUPERCLASS_PROPERTY);
        Object clientEntities = properties.get(CLIENT_SUPPORTED_PROPERTY);
        Object clientPackageName = properties.get(DEFAULT_CLIENT_PACKAGE_PROPERTY);
        Object clientSuperclass = properties.get(DEFAULT_CLIENT_SUPERCLASS_PROPERTY);
        Object quoteSqlIdentifier = properties.get(DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY);
        this.defaultLockType = "optimistic".equals(lockType) ? 1 : 0;
        this.defaultPackage = packageName != null ? packageName.toString() : null;
        this.quotingSQLIdentifiers = quoteSqlIdentifier != null ? "true".equalsIgnoreCase(quoteSqlIdentifier.toString()) : false;
        this.defaultSchema = schema != null ? schema.toString() : null;
        this.defaultSuperclass = superclass != null ? superclass.toString() : null;
        this.clientSupported = clientEntities != null ? "true".equalsIgnoreCase(clientEntities.toString()) : false;
        this.defaultClientPackage = clientPackageName != null ? clientPackageName.toString() : null;
        this.defaultClientSuperclass = clientSuperclass != null ? clientSuperclass.toString() : null;
    }

    public DataMap getClientDataMap(EntityResolver serverResolver) {
        if (!this.isClientSupported()) {
            return null;
        }
        DataMap clientMap = new DataMap(this.getName());
        for (ObjEntity entity : this.getObjEntities()) {
            if (!entity.isClientAllowed()) continue;
            clientMap.addObjEntity(entity.getClientEntity());
        }
        for (Query q : this.getQueries()) {
            NamedQuery proxy = new NamedQuery(q.getName());
            proxy.setName(q.getName());
            proxy.initMetadata(q.getMetaData(serverResolver));
            clientMap.addQuery(proxy);
        }
        return clientMap;
    }

    public void encodeAsXML(PrintWriter pw) {
        XMLEncoder encoder = new XMLEncoder(pw, "\t");
        encoder.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.encodeAsXML(encoder);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.println("<data-map xmlns=\"http://cayenne.apache.org/schema/3.0/modelMap\"");
        encoder.println("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        encoder.println("  xsi:schemaLocation=\"http://cayenne.apache.org/schema/3.0/modelMap http://cayenne.apache.org/schema/3.0/modelMap\"");
        encoder.println("  project-version=\"3.0\">");
        encoder.indent(1);
        if (this.defaultLockType == 1) {
            encoder.printProperty(DEFAULT_LOCK_TYPE_PROPERTY, "optimistic");
        }
        if (!Util.isEmptyString(this.defaultPackage)) {
            encoder.printProperty(DEFAULT_PACKAGE_PROPERTY, this.defaultPackage);
        }
        if (!Util.isEmptyString(this.defaultSchema)) {
            encoder.printProperty(DEFAULT_SCHEMA_PROPERTY, this.defaultSchema);
        }
        if (!Util.isEmptyString(this.defaultSuperclass)) {
            encoder.printProperty(DEFAULT_SUPERCLASS_PROPERTY, this.defaultSuperclass);
        }
        if (this.quotingSQLIdentifiers.booleanValue()) {
            encoder.printProperty(DEFAULT_QUOTE_SQL_IDENTIFIERS_PROPERTY, this.quotingSQLIdentifiers);
        }
        if (this.clientSupported) {
            encoder.printProperty(CLIENT_SUPPORTED_PROPERTY, "true");
        }
        if (!Util.isEmptyString(this.defaultClientPackage)) {
            encoder.printProperty(DEFAULT_CLIENT_PACKAGE_PROPERTY, this.defaultClientPackage);
        }
        if (!Util.isEmptyString(this.defaultClientSuperclass)) {
            encoder.printProperty(DEFAULT_CLIENT_SUPERCLASS_PROPERTY, this.defaultClientSuperclass);
        }
        encoder.print(this.getEmbeddableMap());
        encoder.print(this.getProcedureMap());
        for (DbEntity dbe : this.getDbEntityMap().values()) {
            dbe.encodeAsXML(encoder);
        }
        encoder.print(this.getObjEntityMap());
        this.encodeDBRelationshipsAsXML(this.getDbEntityMap(), encoder);
        this.encodeOBJRelationshipsAsXML(this.getObjEntityMap(), encoder);
        encoder.print(this.getQueryMap());
        for (EntityListener entityListener : this.getDefaultEntityListeners()) {
            entityListener.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</data-map>");
    }

    private final void encodeDBRelationshipsAsXML(Map<String, DbEntity> entityMap, XMLEncoder encoder) {
        for (DbEntity entity : entityMap.values()) {
            for (Relationship relationship : ((Entity)entity).getRelationships()) {
                if (relationship.isRuntime()) continue;
                relationship.encodeAsXML(encoder);
            }
        }
    }

    private final void encodeOBJRelationshipsAsXML(Map<String, ObjEntity> entityMap, XMLEncoder encoder) {
        for (ObjEntity entity : entityMap.values()) {
            for (ObjRelationship relationship : entity.getDeclaredRelationships()) {
                if (relationship.isRuntime()) continue;
                relationship.encodeAsXML(encoder);
            }
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void mergeWithDataMap(DataMap map) {
        for (DbEntity dbEntity : new ArrayList<DbEntity>(map.getDbEntities())) {
            this.removeDbEntity(dbEntity.getName());
            this.addDbEntity(dbEntity);
        }
        for (ObjEntity objEntity : new ArrayList<ObjEntity>(map.getObjEntities())) {
            this.removeObjEntity(objEntity.getName());
            this.addObjEntity(objEntity);
        }
        for (Query query : new ArrayList<Query>(map.getQueries())) {
            this.removeQuery(query.getName());
            this.addQuery(query);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public SortedMap<String, ObjEntity> getObjEntityMap() {
        return Collections.unmodifiableSortedMap(this.objEntityMap);
    }

    public SortedMap<String, DbEntity> getDbEntityMap() {
        return Collections.unmodifiableSortedMap(this.dbEntityMap);
    }

    @Override
    public Query getQuery(String queryName) {
        Query query = (Query)this.queryMap.get(queryName);
        if (query != null) {
            return query;
        }
        return this.namespace != null ? this.namespace.getQuery(queryName) : null;
    }

    public void addQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("Can't add null query.");
        }
        if (query.getName() == null) {
            throw new NullPointerException("Query name can't be null.");
        }
        Object existingQuery = this.queryMap.get(query.getName());
        if (existingQuery != null) {
            if (existingQuery == query) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + query.getName());
        }
        this.queryMap.put(query.getName(), query);
    }

    public void removeQuery(String queryName) {
        this.queryMap.remove(queryName);
    }

    public void clearEmbeddables() {
        this.embeddablesMap.clear();
    }

    public void clearResultSets() {
        this.results.clear();
    }

    public void clearQueries() {
        this.queryMap.clear();
    }

    public void clearObjEntities() {
        this.objEntityMap.clear();
    }

    public void clearDbEntities() {
        this.dbEntityMap.clear();
    }

    public void clearProcedures() {
        this.procedureMap.clear();
    }

    public SortedMap<String, Query> getQueryMap() {
        return Collections.unmodifiableSortedMap(this.queryMap);
    }

    @Override
    public Collection<Query> getQueries() {
        return Collections.unmodifiableCollection(this.queryMap.values());
    }

    public void addEmbeddable(Embeddable embeddable) {
        if (embeddable == null) {
            throw new NullPointerException("Null embeddable");
        }
        if (embeddable.getClassName() == null) {
            throw new NullPointerException("Attempt to add Embeddable with no class name.");
        }
        Object existing = this.embeddablesMap.get(embeddable.getClassName());
        if (existing != null) {
            if (existing == embeddable) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override embeddable '" + embeddable.getClassName());
        }
        this.embeddablesMap.put(embeddable.getClassName(), embeddable);
    }

    public void addResult(SQLResult result) {
        if (result == null) {
            throw new NullPointerException("Null result");
        }
        if (result.getName() == null) {
            throw new NullPointerException("Attempt to add resultSetMapping with no name.");
        }
        Object existing = this.results.get(result.getName());
        if (existing != null) {
            if (existing == result) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override resultSetMapping '" + result.getName());
        }
        this.results.put(result.getName(), result);
    }

    public void addObjEntity(ObjEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add ObjEntity with no name.");
        }
        Object existingEntity = this.objEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + entity.getName());
        }
        this.objEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    public void addDbEntity(DbEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add DbEntity with no name.");
        }
        Object existingEntity = this.dbEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + entity.getName());
        }
        this.dbEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        return Collections.unmodifiableCollection(this.objEntityMap.values());
    }

    public Map<String, Embeddable> getEmbeddableMap() {
        return Collections.unmodifiableMap(this.embeddablesMap);
    }

    public Collection<Embeddable> getEmbeddables() {
        return Collections.unmodifiableCollection(this.embeddablesMap.values());
    }

    public Map<String, SQLResult> getResultsMap() {
        return Collections.unmodifiableMap(this.results);
    }

    public Collection<SQLResult> getResults() {
        return Collections.unmodifiableCollection(this.results.values());
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        Embeddable e = (Embeddable)this.embeddablesMap.get(className);
        if (e != null) {
            return e;
        }
        return this.namespace != null ? this.namespace.getEmbeddable(className) : null;
    }

    @Override
    public SQLResult getResult(String name) {
        SQLResult rsMapping = (SQLResult)this.results.get(name);
        if (rsMapping != null) {
            return rsMapping;
        }
        return this.namespace != null ? this.namespace.getResult(name) : null;
    }

    public List<EntityListener> getDefaultEntityListeners() {
        return Collections.unmodifiableList(this.defaultEntityListeners);
    }

    public void addDefaultEntityListener(EntityListener listener) {
        for (EntityListener next : this.defaultEntityListeners) {
            if (!listener.getClassName().equals(next.getClassName())) continue;
            throw new IllegalArgumentException("Duplicate default listener for " + next.getClassName());
        }
        this.defaultEntityListeners.add(listener);
    }

    public void removeDefaultEntityListener(String className) {
        Iterator<EntityListener> it = this.defaultEntityListeners.iterator();
        while (it.hasNext()) {
            EntityListener next = it.next();
            if (!className.equals(next.getClassName())) continue;
            it.remove();
            break;
        }
    }

    public EntityListener getDefaultEntityListener(String className) {
        for (EntityListener listener : this.defaultEntityListeners) {
            if (!className.equals(listener.getClassName())) continue;
            return listener;
        }
        return null;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        return Collections.unmodifiableCollection(this.dbEntityMap.values());
    }

    @Override
    public DbEntity getDbEntity(String dbEntityName) {
        DbEntity entity = (DbEntity)this.dbEntityMap.get(dbEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getDbEntity(dbEntityName) : null;
    }

    public ObjEntity getObjEntityForJavaClass(String javaClassName) {
        if (javaClassName == null) {
            return null;
        }
        for (ObjEntity entity : this.getObjEntities()) {
            if (!javaClassName.equals(entity.getClassName())) continue;
            return entity;
        }
        return null;
    }

    @Override
    public ObjEntity getObjEntity(String objEntityName) {
        ObjEntity entity = (ObjEntity)this.objEntityMap.get(objEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getObjEntity(objEntityName) : null;
    }

    public Collection<ObjEntity> getMappedEntities(DbEntity dbEntity) {
        Collection<ObjEntity> allEntities;
        if (dbEntity == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<ObjEntity> collection = allEntities = this.namespace != null ? this.namespace.getObjEntities() : this.getObjEntities();
        if (allEntities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ObjEntity> result = new ArrayList<ObjEntity>();
        for (ObjEntity entity : allEntities) {
            if (entity.getDbEntity() != dbEntity) continue;
            result.add(entity);
        }
        return result;
    }

    public void removeEmbeddable(String className) {
        this.embeddablesMap.remove(className);
    }

    public void removeResult(String name) {
        this.results.remove(name);
    }

    public void removeDbEntity(String dbEntityName) {
        this.removeDbEntity(dbEntityName, false);
    }

    public void removeDbEntity(String dbEntityName, boolean clearDependencies) {
        DbEntity dbEntityToDelete = (DbEntity)this.dbEntityMap.remove(dbEntityName);
        if (dbEntityToDelete != null && clearDependencies) {
            for (DbEntity dbEnt : this.getDbEntities()) {
                for (Relationship relationship : new ArrayList<DbRelationship>(dbEnt.getRelationships())) {
                    if (!dbEntityName.equals(relationship.getTargetEntityName())) continue;
                    dbEnt.removeRelationship(relationship.getName());
                }
            }
            for (ObjEntity objEnt : this.getObjEntities()) {
                if (objEnt.getDbEntity() == dbEntityToDelete) {
                    objEnt.clearDbMapping();
                    continue;
                }
                block3: for (ObjRelationship objRelationship : objEnt.getRelationships()) {
                    for (DbRelationship dbRel : objRelationship.getDbRelationships()) {
                        if (dbRel.getTargetEntity() != dbEntityToDelete) continue;
                        objRelationship.clearDbRelationships();
                        continue block3;
                    }
                }
            }
        }
    }

    public void removeObjEntity(String objEntityName) {
        this.removeObjEntity(objEntityName, false);
    }

    public void removeObjEntity(String objEntityName, boolean clearDependencies) {
        ObjEntity entity = (ObjEntity)this.objEntityMap.remove(objEntityName);
        if (entity != null && clearDependencies) {
            for (ObjEntity ent : this.getObjEntities()) {
                for (Relationship relationship : new ArrayList<ObjRelationship>(ent.getRelationships())) {
                    if (!objEntityName.equals(relationship.getTargetEntityName()) && !objEntityName.equals(relationship.getTargetEntityName())) continue;
                    ent.removeRelationship(relationship.getName());
                }
            }
        }
    }

    @Override
    public Collection<Procedure> getProcedures() {
        return Collections.unmodifiableCollection(this.procedureMap.values());
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        Procedure procedure = (Procedure)this.procedureMap.get(procedureName);
        if (procedure != null) {
            return procedure;
        }
        return this.namespace != null ? this.namespace.getProcedure(procedureName) : null;
    }

    public void addProcedure(Procedure procedure) {
        if (procedure.getName() == null) {
            throw new NullPointerException("Attempt to add procedure with no name.");
        }
        Object existingProcedure = this.procedureMap.get(procedure.getName());
        if (existingProcedure != null) {
            if (existingProcedure == procedure) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override procedure '" + procedure.getName());
        }
        this.procedureMap.put(procedure.getName(), procedure);
        procedure.setDataMap(this);
    }

    public void removeProcedure(String name) {
        this.procedureMap.remove(name);
    }

    public SortedMap<String, Procedure> getProcedureMap() {
        return Collections.unmodifiableSortedMap(this.procedureMap);
    }

    public MappingNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(MappingNamespace namespace) {
        this.namespace = namespace;
    }

    public int getDefaultLockType() {
        return this.defaultLockType;
    }

    public void setDefaultLockType(int defaultLockType) {
        this.defaultLockType = defaultLockType;
    }

    public boolean isClientSupported() {
        return this.clientSupported;
    }

    public void setClientSupported(boolean clientSupport) {
        this.clientSupported = clientSupport;
    }

    public String getDefaultClientPackage() {
        return this.defaultClientPackage;
    }

    public void setDefaultClientPackage(String defaultClientPackage) {
        this.defaultClientPackage = defaultClientPackage;
    }

    public String getDefaultClientSuperclass() {
        return this.defaultClientSuperclass;
    }

    public void setDefaultClientSuperclass(String defaultClientSuperclass) {
        this.defaultClientSuperclass = defaultClientSuperclass;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getDefaultSuperclass() {
        return this.defaultSuperclass;
    }

    public void setDefaultSuperclass(String defaultSuperclass) {
        this.defaultSuperclass = defaultSuperclass;
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)entity;
            dbEntity.dbEntityChanged(e);
            if (e.isNameChange()) {
                this.dbEntityMap.remove(e.getOldName());
                this.dbEntityMap.put(e.getNewName(), dbEntity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).clearCache();
                }
            }
        }
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
    }

    public void dbAttributeChanged(AttributeEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            ((DbEntity)entity).dbAttributeChanged(e);
        }
    }

    public void dbAttributeAdded(AttributeEvent e) {
    }

    public void dbAttributeRemoved(AttributeEvent e) {
    }

    public void dbRelationshipChanged(RelationshipEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            ((DbEntity)entity).dbRelationshipChanged(e);
        }
    }

    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    public void dbRelationshipRemoved(RelationshipEvent e) {
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)entity;
            objEntity.objEntityChanged(e);
            if (e.isNameChange()) {
                this.objEntityMap.remove(e.getOldName());
                this.objEntityMap.put(e.getNewName(), objEntity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).clearCache();
                }
            }
        }
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
    }

    public void objAttributeChanged(AttributeEvent e) {
    }

    public void objAttributeAdded(AttributeEvent e) {
    }

    public void objAttributeRemoved(AttributeEvent e) {
    }

    public void objRelationshipChanged(RelationshipEvent e) {
    }

    public void objRelationshipAdded(RelationshipEvent e) {
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
    }
}

