/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.OptimisticLockException;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.trans.BatchQueryBuilder;
import org.apache.cayenne.access.trans.DeleteBatchQueryBuilder;
import org.apache.cayenne.access.trans.InsertBatchQueryBuilder;
import org.apache.cayenne.access.trans.UpdateBatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;

public class BatchAction
extends BaseSQLAction {
    protected boolean batch;
    protected BatchQuery query;
    protected RowDescriptor keyRowDescriptor;

    public BatchAction(BatchQuery batchQuery, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = batchQuery;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean runningAsBatch) {
        this.batch = runningAsBatch;
    }

    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        BatchQueryBuilder queryBuilder = this.createBuilder();
        boolean generatesKeys = this.hasGeneratedKeys();
        if (this.batch && !generatesKeys) {
            this.runAsBatch(connection, queryBuilder, observer);
        } else {
            this.runAsIndividualQueries(connection, queryBuilder, observer, generatesKeys);
        }
    }

    protected BatchQueryBuilder createBuilder() throws CayenneException {
        if (this.query instanceof InsertBatchQuery) {
            return new InsertBatchQueryBuilder(this.getAdapter());
        }
        if (this.query instanceof UpdateBatchQuery) {
            return new UpdateBatchQueryBuilder(this.getAdapter());
        }
        if (this.query instanceof DeleteBatchQuery) {
            return new DeleteBatchQueryBuilder(this.getAdapter());
        }
        throw new CayenneException("Unsupported batch query: " + this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsBatch(Connection con, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
        String queryStr = queryBuilder.createSqlString(this.query);
        boolean isLoggable = QueryLogger.isLoggable();
        QueryLogger.logQuery(queryStr, Collections.EMPTY_LIST);
        this.query.reset();
        PreparedStatement statement = con.prepareStatement(queryStr);
        try {
            while (this.query.next()) {
                if (isLoggable) {
                    QueryLogger.logQueryParameters("batch bind", this.query.getDbAttributes(), queryBuilder.getParameterValues(this.query), this.query instanceof InsertBatchQuery);
                }
                queryBuilder.bindParameters(statement, this.query);
                statement.addBatch();
            }
            int[] results = statement.executeBatch();
            delegate.nextBatchCount(this.query, results);
            if (isLoggable) {
                int totalUpdateCount = 0;
                for (int result : results) {
                    if (result < 0) {
                        totalUpdateCount = -2;
                        break;
                    }
                    totalUpdateCount += result;
                }
                QueryLogger.logUpdateCount(totalUpdateCount);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsIndividualQueries(Connection connection, BatchQueryBuilder queryBuilder, OperationObserver delegate, boolean generatesKeys) throws SQLException, Exception {
        boolean isLoggable = QueryLogger.isLoggable();
        boolean useOptimisticLock = this.query.isUsingOptimisticLocking();
        String queryStr = queryBuilder.createSqlString(this.query);
        QueryLogger.logQuery(queryStr, Collections.EMPTY_LIST);
        this.query.reset();
        PreparedStatement statement = generatesKeys ? connection.prepareStatement(queryStr, 1) : connection.prepareStatement(queryStr);
        try {
            while (this.query.next()) {
                if (isLoggable) {
                    QueryLogger.logQueryParameters("bind", this.query.getDbAttributes(), queryBuilder.getParameterValues(this.query), this.query instanceof InsertBatchQuery);
                }
                queryBuilder.bindParameters(statement, this.query);
                int updated = statement.executeUpdate();
                if (useOptimisticLock && updated != 1) {
                    Map snapshot = Collections.EMPTY_MAP;
                    if (this.query instanceof UpdateBatchQuery) {
                        snapshot = ((UpdateBatchQuery)this.query).getCurrentQualifier();
                    } else if (this.query instanceof DeleteBatchQuery) {
                        snapshot = ((DeleteBatchQuery)this.query).getCurrentQualifier();
                    }
                    throw new OptimisticLockException(this.query.getDbEntity(), queryStr, snapshot);
                }
                delegate.nextCount(this.query, updated);
                if (generatesKeys) {
                    this.processGeneratedKeys(statement, delegate);
                }
                if (!isLoggable) continue;
                QueryLogger.logUpdateCount(updated);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    protected boolean hasGeneratedKeys() {
        if (!this.adapter.supportsGeneratedKeys()) {
            return false;
        }
        if (this.query instanceof InsertBatchQuery) {
            for (DbAttribute attr : this.query.getDbEntity().getGeneratedAttributes()) {
                if (!attr.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    protected void processGeneratedKeys(Statement statement, OperationObserver observer) throws SQLException, CayenneException {
        ResultSet keysRS = statement.getGeneratedKeys();
        RowDescriptorBuilder builder = new RowDescriptorBuilder();
        if (this.keyRowDescriptor == null) {
            Collection<DbAttribute> generated = this.query.getDbEntity().getGeneratedAttributes();
            if (generated.size() == 1) {
                DbAttribute key = generated.iterator().next();
                ColumnDescriptor[] columns = new ColumnDescriptor[]{new ColumnDescriptor(keysRS.getMetaData(), 1)};
                columns[0].setJdbcType(key.getType());
                columns[0].setJavaClass(TypesMapping.getJavaBySqlType(key.getType()));
                builder.setColumns(columns);
            } else {
                builder.setResultSet(keysRS);
            }
            this.keyRowDescriptor = builder.getDescriptor(this.getAdapter().getExtendedTypes());
        }
        JDBCResultIterator iterator = new JDBCResultIterator(null, null, keysRS, this.keyRowDescriptor, this.query.getMetaData(this.getEntityResolver()));
        observer.nextGeneratedRows(this.query, iterator);
    }
}

