/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.cache.MapQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseContext
implements ObjectContext,
DataChannel {
    protected static final ThreadLocal<ObjectContext> threadObjectContext = new ThreadLocal();
    protected transient DataChannel channel;
    protected QueryCache queryCache;
    protected Map<String, Object> userProperties;

    public static ObjectContext getThreadObjectContext() throws IllegalStateException {
        ObjectContext context = threadObjectContext.get();
        if (context == null) {
            throw new IllegalStateException("Current thread has no bound ObjectContext.");
        }
        return context;
    }

    public static void bindThreadObjectContext(ObjectContext context) {
        threadObjectContext.set(context);
    }

    @Override
    public abstract void commitChanges();

    @Override
    public abstract void commitChangesToParent();

    @Override
    public abstract void deleteObject(Object var1) throws DeleteDenyException;

    @Override
    public abstract Collection<?> deletedObjects();

    @Override
    public DataChannel getChannel() {
        return this.channel;
    }

    @Override
    public abstract EntityResolver getEntityResolver();

    @Override
    public abstract GraphManager getGraphManager();

    @Override
    public abstract Persistent localObject(ObjectId var1, Object var2);

    @Override
    public abstract Collection<?> modifiedObjects();

    @Override
    public abstract <T> T newObject(Class<T> var1);

    @Override
    public abstract void registerNewObject(Object var1);

    @Override
    public abstract Collection<?> newObjects();

    @Override
    public abstract QueryResponse performGenericQuery(Query var1);

    @Override
    public abstract List performQuery(Query var1);

    @Override
    @Deprecated
    public void prepareForAccess(Persistent object, String property) {
        this.prepareForAccess(object, property, false);
    }

    @Override
    public void prepareForAccess(Persistent object, String property, boolean lazyFaulting) {
        if (object.getPersistenceState() == 5) {
            ObjectId oid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(oid, false, 1));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for ObjectId: " + oid);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for ObjectId: " + oid);
            }
            if (object.getPersistenceState() != 3) {
                String state = PersistenceState.persistenceStateName(object.getPersistenceState());
                throw new FaultFailureException("Error resolving fault for ObjectId: " + oid + " and state (" + state + "). Possible cause - matching row is missing from the database.");
            }
        }
        if (lazyFaulting && property != null) {
            ClassDescriptor classDescriptor = this.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
            Property propertyDescriptor = classDescriptor.getProperty(property);
            if (propertyDescriptor == null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(String.format("Property '%s' is not declared for entity '%s'.", property, object.getObjectId().getEntityName()));
                errorMessage.append(" Declared properties are: ");
                final ArrayList properties = new ArrayList();
                classDescriptor.visitProperties(new PropertyVisitor(){

                    public boolean visitAttribute(AttributeProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    public boolean visitToOne(ToOneProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    public boolean visitToMany(ToManyProperty property) {
                        properties.add(property.getName());
                        return true;
                    }
                });
                boolean first = true;
                for (String declaredProperty : properties) {
                    if (first) {
                        errorMessage.append(String.format("'%s'", declaredProperty));
                        first = false;
                        continue;
                    }
                    errorMessage.append(String.format(", '%s'", declaredProperty));
                }
                errorMessage.append(".");
                throw new CayenneRuntimeException(errorMessage.toString());
            }
            propertyDescriptor.readProperty(object);
        }
    }

    @Override
    public abstract void propertyChanged(Persistent var1, String var2, Object var3, Object var4);

    @Override
    public abstract void rollbackChanges();

    @Override
    public abstract void rollbackChangesLocally();

    @Override
    public abstract Collection<?> uncommittedObjects();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCache getQueryCache() {
        if (this.queryCache == null) {
            BaseContext baseContext = this;
            synchronized (baseContext) {
                if (this.queryCache == null) {
                    this.queryCache = new MapQueryCache();
                }
            }
        }
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @Override
    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback(originatingContext);
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType);
    }

    GraphDiff onContextRollback(ObjectContext originatingContext) {
        this.rollbackChanges();
        return new CompoundDiff();
    }

    protected abstract GraphDiff onContextFlush(ObjectContext var1, GraphDiff var2, boolean var3);

    protected void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    protected void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    protected void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    @Override
    public void invalidateObjects(Collection objects) {
        this.performGenericQuery(new RefreshQuery(objects));
    }

    protected Map<String, Object> getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, Object>();
        }
        return this.userProperties;
    }

    @Override
    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    @Override
    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }
}

