/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.reveng.BasicNamingStrategy;
import org.apache.cayenne.access.reveng.NamingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.util.EntityMergeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMergeSupport {
    protected DataMap map;
    protected boolean removeMeaningfulFKs;
    protected NamingStrategy namingStrategy;
    protected List<EntityMergeListener> listeners;

    public EntityMergeSupport(DataMap map) {
        this(map, new BasicNamingStrategy());
    }

    public EntityMergeSupport(DataMap map, NamingStrategy namingStrategy) {
        this.map = map;
        this.removeMeaningfulFKs = true;
        this.listeners = new ArrayList<EntityMergeListener>();
        this.namingStrategy = namingStrategy;
    }

    public boolean synchronizeWithDbEntities(Collection<ObjEntity> objEntities) {
        boolean changed = false;
        for (ObjEntity nextEntity : objEntities) {
            if (!this.synchronizeWithDbEntity(nextEntity)) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null || entity.getDbEntity() == null) {
            return false;
        }
        boolean changed = false;
        DataMap dataMap = this.map;
        synchronized (dataMap) {
            if (this.removeMeaningfulFKs) {
                for (DbAttribute da : this.getMeaningfulFKs(entity)) {
                    ObjAttribute oa = entity.getAttributeForDbAttribute(da);
                    while (oa != null) {
                        String attrName = oa.getName();
                        entity.removeAttribute(attrName);
                        changed = true;
                        oa = entity.getAttributeForDbAttribute(da);
                    }
                }
            }
            for (DbAttribute da : this.getAttributesToAdd(entity)) {
                String attrName = this.namingStrategy.createObjAttributeName(da);
                attrName = NamedObjectFactory.createName(ObjAttribute.class, entity, attrName);
                String type = TypesMapping.getJavaBySqlType(da.getType());
                ObjAttribute oa = new ObjAttribute(attrName, type, entity);
                oa.setDbAttributePath(da.getName());
                entity.addAttribute(oa);
                this.fireAttributeAdded(oa);
                changed = true;
            }
            for (DbRelationship dr : this.getRelationshipsToAdd(entity)) {
                DbEntity dbEntity = (DbEntity)dr.getTargetEntity();
                for (ObjEntity mappedTarget : this.map.getMappedEntities(dbEntity)) {
                    String relationshipName = this.namingStrategy.createObjRelationshipName(dr);
                    relationshipName = NamedObjectFactory.createName(ObjRelationship.class, entity, relationshipName);
                    ObjRelationship or = new ObjRelationship(relationshipName);
                    or.addDbRelationship(dr);
                    or.setSourceEntity(entity);
                    or.setTargetEntity(mappedTarget);
                    entity.addRelationship(or);
                    this.fireRelationshipAdded(or);
                    changed = true;
                }
            }
        }
        return changed;
    }

    public Collection<DbAttribute> getMeaningfulFKs(ObjEntity objEntity) {
        ArrayList<DbAttribute> fks = new ArrayList<DbAttribute>(2);
        for (ObjAttribute property : objEntity.getAttributes()) {
            DbAttribute column = property.getDbAttribute();
            if (column == null || !column.isForeignKey()) continue;
            fks.add(column);
        }
        return fks;
    }

    protected List<DbAttribute> getAttributesToAdd(ObjEntity objEntity) {
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Collection<DbRelationship> rels = objEntity.getDbEntity().getRelationships();
        Collection<DbRelationship> incomingRels = this.getIncomingRelationships(objEntity.getDbEntity());
        for (DbAttribute dba : objEntity.getDbEntity().getAttributes()) {
            DbRelationship rel;
            if (objEntity.getAttributeForDbAttribute(dba) != null || dba.getName() == null || dba.isPrimaryKey()) continue;
            boolean isFK = false;
            Iterator<DbRelationship> rit = rels.iterator();
            block1: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getSource() != dba) continue;
                    isFK = true;
                    continue block1;
                }
            }
            if (isFK) continue;
            rit = incomingRels.iterator();
            block3: while (!isFK && rit.hasNext()) {
                rel = rit.next();
                for (DbJoin join : rel.getJoins()) {
                    if (join.getTarget() != dba) continue;
                    isFK = true;
                    continue block3;
                }
            }
            if (isFK) continue;
            missing.add(dba);
        }
        return missing;
    }

    private Collection<DbRelationship> getIncomingRelationships(DbEntity entity) {
        ArrayList<DbRelationship> incoming = new ArrayList<DbRelationship>();
        for (DbEntity nextEntity : entity.getDataMap().getDbEntities()) {
            for (DbRelationship relationship : nextEntity.getRelationships()) {
                if (entity != relationship.getTargetEntity()) continue;
                incoming.add(relationship);
            }
        }
        return incoming;
    }

    protected List<DbRelationship> getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        for (DbRelationship dbrel : objEntity.getDbEntity().getRelationships()) {
            if (dbrel.getName() == null || objEntity.getRelationshipForDbRelationship(dbrel) != null) continue;
            missing.add(dbrel);
        }
        return missing;
    }

    public DataMap getMap() {
        return this.map;
    }

    public void setMap(DataMap map) {
        this.map = map;
    }

    public boolean isRemoveMeaningfulFKs() {
        return this.removeMeaningfulFKs;
    }

    public void setRemoveMeaningfulFKs(boolean removeMeaningfulFKs) {
        this.removeMeaningfulFKs = removeMeaningfulFKs;
    }

    public void addEntityMergeListener(EntityMergeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntityMergeListener(EntityMergeListener listener) {
        this.listeners.remove(listener);
    }

    public EntityMergeListener[] getEntityMergeListeners() {
        return this.listeners.toArray(new EntityMergeListener[0]);
    }

    protected void fireAttributeAdded(ObjAttribute attr) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objAttributeAdded(attr);
        }
    }

    protected void fireRelationshipAdded(ObjRelationship rel) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objRelationshipAdded(rel);
        }
    }

    public void setNamingStrategy(NamingStrategy strategy) {
        this.namingStrategy = strategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

