/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.reflect;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseToManyProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;

abstract class JpaToManyProperty
extends BaseToManyProperty {
    JpaToManyProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.accessor.setValue(object, newValue);
    }

    protected ValueHolder ensureCollectionValueHolderSet(Object object) throws PropertyException {
        Object value = this.accessor.getValue(object);
        if (value == null || value instanceof Fault) {
            value = this.createCollectionValueHolder(object);
            this.accessor.setValue(object, value);
        } else if (!(value instanceof ValueHolder) && (value instanceof Collection || value instanceof Map)) {
            ValueHolder valueHolder = this.createCollectionValueHolder(object);
            valueHolder.setValueDirectly(value);
            this.accessor.setValue(object, valueHolder);
            value = valueHolder;
        }
        return (ValueHolder)value;
    }

    protected ValueHolder createCollectionValueHolder(Object object) throws PropertyException {
        if (!(object instanceof Persistent)) {
            throw new PropertyException("ValueHolders for non-persistent objects are not supported.", this, object);
        }
        return this.createValueHolder((Persistent)object);
    }

    protected abstract ValueHolder createValueHolder(Persistent var1);

    public boolean isFault(Object object) {
        Object target = this.accessor.getValue(object);
        return target == null || target instanceof Fault || ((ValueHolder)target).isFault();
    }

    public void invalidate(Object object) {
        ValueHolder list = (ValueHolder)this.readPropertyDirectly(object);
        if (list != null) {
            list.invalidate();
        }
    }
}

