/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TemporalType;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

public abstract class JpaQuery
implements javax.persistence.Query {
    protected ObjectContext context;

    public JpaQuery(ObjectContext ctxt) {
        this.context = ctxt;
    }

    protected abstract Query getQuery();

    public List getResultList() {
        return this.context.performQuery(this.getQuery());
    }

    public int executeUpdate() {
        QueryResponse response = this.context.performGenericQuery(this.getQuery());
        int[] res = response.firstUpdateCount();
        if (res == null) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < res.length; ++i) {
            num += res[i];
        }
        return num;
    }

    public Object getSingleResult() {
        List rows = this.getResultList();
        if (rows.size() == 0) {
            throw new NoResultException();
        }
        if (rows.size() > 1) {
            throw new NonUniqueResultException();
        }
        return rows.get(0);
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Invalid max results value: " + maxResult);
        }
        Query query = this.getQuery();
        if (query instanceof EJBQLQuery) {
            ((EJBQLQuery)query).setFetchLimit(maxResult);
        } else if (query instanceof SQLTemplate) {
            ((SQLTemplate)query).setFetchLimit(maxResult);
        } else if (query instanceof SelectQuery) {
            ((SelectQuery)query).setFetchLimit(maxResult);
        } else if (query instanceof ProcedureQuery) {
            ((ProcedureQuery)query).setFetchLimit(maxResult);
        } else {
            throw new IllegalArgumentException("query does not support maxResult: " + query);
        }
        return this;
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushModeType) {
        return this;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        return this;
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("Invalid first result value: " + startPosition);
        }
        Query query = this.getQuery();
        if (query instanceof EJBQLQuery) {
            ((EJBQLQuery)query).setFetchOffset(startPosition);
        } else if (query instanceof SQLTemplate) {
            ((SQLTemplate)query).setFetchOffset(startPosition);
        } else if (query instanceof SelectQuery) {
            ((SelectQuery)query).setFetchOffset(startPosition);
        } else if (query instanceof ProcedureQuery) {
            ((ProcedureQuery)query).setFetchOffset(startPosition);
        } else {
            throw new IllegalArgumentException("query does not support maxResult: " + query);
        }
        return this;
    }

    public abstract javax.persistence.Query setParameter(String var1, Object var2);

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(name, (Object)value);
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(name, (Object)value);
    }

    public abstract javax.persistence.Query setParameter(int var1, Object var2);

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(position, (Object)value);
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(position, (Object)value);
    }
}

