/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.jpa.JpaQuery;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaNativeQuery
extends JpaQuery {
    private static final String POSITIONAL_PARAM_PREFIX = "positional_";
    protected SQLTemplate query;
    protected Map<String, Object> parameters;

    public JpaNativeQuery(ObjectContext context, String sqlString, Class<?> resultClass) {
        super(context);
        this.query = new SQLTemplate(resultClass, this.processSQLString(sqlString));
    }

    public JpaNativeQuery(ObjectContext context, String sqlString, String dataMapName) {
        this(context, sqlString, dataMapName, null);
    }

    public JpaNativeQuery(ObjectContext context, String sqlString, String dataMapName, String resultSetMappingName) {
        super(context);
        DataMap map = context.getEntityResolver().getDataMap(dataMapName);
        this.query = new SQLTemplate(map, this.processSQLString(sqlString));
        if (resultSetMappingName != null) {
            this.query.setResultSetMapping(map.getResultSetMapping(resultSetMappingName));
        }
    }

    protected String processSQLString(String sqlString) {
        if ((sqlString = sqlString.replace(':', '$')).indexOf(63) >= 0) {
            sqlString = sqlString.replaceAll("\\?([0-9]+)", "\\$positional_$1");
        }
        return sqlString;
    }

    @Override
    protected Query getQuery() {
        return this.query;
    }

    @Override
    public javax.persistence.Query setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
        this.query.setParameters(this.parameters);
        return this;
    }

    @Override
    public javax.persistence.Query setParameter(int position, Object value) {
        String name = POSITIONAL_PARAM_PREFIX + Integer.toString(position);
        try {
            return this.setParameter(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid positional parameter: " + position, e);
        }
    }
}

