/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.DefaultType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.openbase.OpenBaseActionBuilder;
import org.apache.cayenne.dba.openbase.OpenBaseMergerFactory;
import org.apache.cayenne.dba.openbase.OpenBasePkGenerator;
import org.apache.cayenne.dba.openbase.OpenBaseQualifierTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class OpenBaseAdapter
extends JdbcAdapter {
    public OpenBaseAdapter() {
        this.setSupportsUniqueConstraints(false);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new OpenBaseActionBuilder(this, node.getEntityResolver()));
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new OpenBaseByteType());
        map.registerType(new OpenBaseCharType());
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        if (type == 1) {
            type = 12;
        }
        return super.buildAttribute(name, typeName, type, size, scale, allowNulls);
    }

    public String getBatchTerminator() {
        return "go";
    }

    public String tableTypeForView() {
        return null;
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new OpenBaseQualifierTranslator(queryAssembler);
    }

    protected PkGenerator createPkGenerator() {
        return new OpenBasePkGenerator();
    }

    public String createTable(DbEntity ent) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator<DbAttribute> it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int scale;
                int len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (at.isMandatory()) {
                buf.append(" NOT NULL");
                continue;
            }
            buf.append(" NULL");
        }
        buf.append(')');
        return buf.toString();
    }

    public String createFkConstraint(DbRelationship rel) {
        StringBuilder buf = new StringBuilder();
        DbEntity sourceEntity = (DbEntity)rel.getSourceEntity();
        DbEntity targetEntity = (DbEntity)rel.getTargetEntity();
        String toMany = !rel.isToMany() ? "'1'" : "'0'";
        int joinsLen = rel.getJoins().size();
        if (joinsLen == 0) {
            throw new CayenneRuntimeException("Relationship has no joins: " + rel.getName());
        }
        if (joinsLen > 1) {
            // empty if block
        }
        DbJoin join = rel.getJoins().get(0);
        buf.append("INSERT INTO _SYS_RELATIONSHIP (").append("dest_table, dest_column, source_table, source_column, ").append("block_delete, cascade_delete, one_to_many, operator, relationshipName").append(") VALUES ('").append(sourceEntity.getFullyQualifiedName()).append("', '").append(join.getSourceName()).append("', '").append(targetEntity.getFullyQualifiedName()).append("', '").append(join.getTargetName()).append("', 0, 0, ").append(toMany).append(", '=', '").append(rel.getName()).append("')");
        return buf.toString();
    }

    public MergerFactory mergerFactory() {
        return new OpenBaseMergerFactory();
    }

    static class OpenBaseCharType
    extends CharType {
        OpenBaseCharType() {
            super(false, true);
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (type == 2005 || type == -1) {
                st.setString(pos, (String)val);
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }

    static class OpenBaseByteType
    extends DefaultType {
        OpenBaseByteType() {
            super(Byte.class.getName());
        }

        public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
            int val = rs.getInt(index);
            return rs.wasNull() ? null : Byte.valueOf((byte)val);
        }
    }
}

