/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.trans.JoinStack;
import org.apache.cayenne.access.trans.OrderingTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTranslator
extends QueryAssembler {
    protected static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, -4, -1};
    JoinStack joinStack = this.createJoinStack();
    List<ColumnDescriptor> resultColumns;
    Map<ObjAttribute, ColumnDescriptor> attributeOverrides;
    Map<ColumnDescriptor, ObjAttribute> defaultAttributesByColumn;
    boolean suppressingDistinct;
    boolean forcingDistinct;

    protected static boolean isUnsupportedForDistinct(int type) {
        for (int i = 0; i < UNSUPPORTED_DISTINCT_TYPES.length; ++i) {
            if (UNSUPPORTED_DISTINCT_TYPES[i] != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public DbEntity getRootDbEntity() {
        return this.query.getMetaData(this.entityResolver).getDbEntity();
    }

    @Override
    public ObjEntity getRootEntity() {
        return this.query.getMetaData(this.entityResolver).getObjEntity();
    }

    protected JoinStack createJoinStack() {
        return new JoinStack();
    }

    @Override
    public String createSqlString() throws Exception {
        this.forcingDistinct = false;
        this.resultColumns = this.buildResultColumns();
        StringBuilder qualifierBuffer = this.adapter.getQualifierTranslator(this).appendPart(new StringBuilder());
        OrderingTranslator orderingTranslator = new OrderingTranslator(this);
        StringBuilder orderingBuffer = orderingTranslator.appendPart(new StringBuilder());
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            this.suppressingDistinct = false;
            for (ColumnDescriptor column : this.resultColumns) {
                if (!SelectTranslator.isUnsupportedForDistinct(column.getJdbcType())) continue;
                this.suppressingDistinct = true;
                break;
            }
            if (!this.suppressingDistinct) {
                queryBuf.append("DISTINCT ");
            }
        }
        ArrayList<String> selectColumnExpList = new ArrayList<String>();
        for (ColumnDescriptor column : this.resultColumns) {
            selectColumnExpList.add(column.getQualifiedColumnName());
        }
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            List<String> orderByColumnList = orderingTranslator.getOrderByColumnList();
            for (String orderByColumnExp : orderByColumnList) {
                if (selectColumnExpList.contains(orderByColumnExp)) continue;
                selectColumnExpList.add(orderByColumnExp);
            }
        }
        int columnCount = selectColumnExpList.size();
        queryBuf.append((String)selectColumnExpList.get(0));
        for (int i = 1; i < columnCount; ++i) {
            queryBuf.append(", ");
            queryBuf.append((String)selectColumnExpList.get(i));
        }
        queryBuf.append(" FROM ");
        this.joinStack.appendRoot(queryBuf, this.getRootDbEntity());
        this.joinStack.appendJoins(queryBuf);
        this.joinStack.appendQualifier(qualifierBuffer, qualifierBuffer.length() == 0);
        if (qualifierBuffer.length() > 0) {
            queryBuf.append(" WHERE ");
            queryBuf.append((CharSequence)qualifierBuffer);
        }
        if (orderingBuffer.length() > 0) {
            queryBuf.append(" ORDER BY ").append((CharSequence)orderingBuffer);
        }
        if (!this.isSuppressingDistinct()) {
            this.appendLimitAndOffsetClauses(queryBuf);
        }
        return queryBuf.toString();
    }

    protected void appendLimitAndOffsetClauses(StringBuilder buffer) {
    }

    @Override
    public String getCurrentAlias() {
        return this.joinStack.getCurrentAlias();
    }

    public ColumnDescriptor[] getResultColumns() {
        if (this.resultColumns == null || this.resultColumns.isEmpty()) {
            return new ColumnDescriptor[0];
        }
        return this.resultColumns.toArray(new ColumnDescriptor[this.resultColumns.size()]);
    }

    public Map<ObjAttribute, ColumnDescriptor> getAttributeOverrides() {
        if (this.attributeOverrides != null) {
            return this.attributeOverrides;
        }
        return Collections.emptyMap();
    }

    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    private SelectQuery getSelectQuery() {
        return (SelectQuery)this.getQuery();
    }

    List<ColumnDescriptor> buildResultColumns() {
        this.defaultAttributesByColumn = new HashMap<ColumnDescriptor, ObjAttribute>();
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        SelectQuery query = this.getSelectQuery();
        if (query.isFetchingCustomAttributes()) {
            this.appendCustomColumns(columns, query);
        } else {
            this.appendQueryColumns(columns, query);
        }
        return columns;
    }

    List<ColumnDescriptor> appendQueryColumns(final List<ColumnDescriptor> columns, SelectQuery query) {
        final HashSet<DbAttribute> attributes = new HashSet<DbAttribute>();
        ClassDescriptor descriptor = query.getMetaData(this.entityResolver).getClassDescriptor();
        ObjEntity oe = descriptor.getEntity();
        PropertyVisitor visitor = new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                SelectTranslator.this.resetJoinStack();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                    }
                    if (pathPart instanceof DbRelationship) {
                        DbRelationship rel = (DbRelationship)pathPart;
                        SelectTranslator.this.dbRelationshipAdded(rel, JoinType.INNER, null);
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    DbAttribute dbAttr = (DbAttribute)pathPart;
                    SelectTranslator.this.appendColumn(columns, oa, dbAttr, attributes, null);
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                List<DbJoin> joins = dbRel.getJoins();
                int len = joins.size();
                for (int i = 0; i < len; ++i) {
                    DbJoin join = joins.get(i);
                    DbAttribute src = join.getSource();
                    SelectTranslator.this.appendColumn(columns, null, src, attributes, null);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        DbEntity table = this.getRootDbEntity();
        for (DbAttribute dba : table.getPrimaryKeys()) {
            this.appendColumn(columns, null, dba, attributes, null);
        }
        if (query instanceof PrefetchSelectQuery) {
            for (String path : ((PrefetchSelectQuery)query).getResultPaths()) {
                Expression pathExp = oe.translateToDbPath(Expression.fromString(path));
                this.resetJoinStack();
                PathComponent<DbAttribute, DbRelationship> lastComponent = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(pathExp, this.getPathAliases())) {
                    if (component.getRelationship() != null && !component.isLast()) {
                        this.dbRelationshipAdded(component.getRelationship(), component.getJoinType(), null);
                    }
                    lastComponent = component;
                }
                String labelPrefix = pathExp.toString().substring("db:".length());
                if (lastComponent == null) continue;
                DbRelationship relationship = lastComponent.getRelationship();
                if (relationship != null) {
                    if (relationship.isToMany()) {
                        this.dbRelationshipAdded(relationship, JoinType.INNER, null);
                    }
                    for (DbJoin j : relationship.getJoins()) {
                        DbAttribute attribute = relationship.isToMany() ? j.getTarget() : j.getSource();
                        this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + j.getTargetName());
                    }
                    continue;
                }
                this.appendColumn(columns, null, lastComponent.getAttribute(), attributes, labelPrefix);
            }
        }
        if (query.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().adjacentJointNodes()) {
                Expression prefetchExp = Expression.fromString(prefetch.getPath());
                Expression dbPrefetch = oe.translateToDbPath(prefetchExp);
                this.resetJoinStack();
                DbRelationship r = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(dbPrefetch, this.getPathAliases())) {
                    r = component.getRelationship();
                    this.dbRelationshipAdded(r, JoinType.LEFT_OUTER, null);
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '" + prefetch + "' for entity: " + oe.getName());
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                Iterator<? extends Attribute> targetObjAttrs = targetRel.getTargetEntity().getAttributes().iterator();
                String labelPrefix = dbPrefetch.toString().substring("db:".length());
                while (targetObjAttrs.hasNext()) {
                    ObjAttribute oa = (ObjAttribute)targetObjAttrs.next();
                    Iterator<CayenneMapEntry> iterator = oa.getDbPathIterator();
                    while (iterator.hasNext()) {
                        CayenneMapEntry pathPart = iterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                        }
                        if (pathPart instanceof DbRelationship) {
                            DbRelationship rel = (DbRelationship)pathPart;
                            this.dbRelationshipAdded(rel, JoinType.INNER, null);
                            continue;
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute attribute = (DbAttribute)pathPart;
                        this.appendColumn(columns, oa, attribute, attributes, labelPrefix + '.' + attribute.getName());
                    }
                }
                for (DbAttribute dbAttribute : r.getTargetEntity().getAttributes()) {
                    this.appendColumn(columns, null, dbAttribute, attributes, labelPrefix + '.' + dbAttribute.getName());
                }
            }
        }
        return columns;
    }

    List<ColumnDescriptor> appendCustomColumns(List<ColumnDescriptor> columns, SelectQuery query) {
        List<String> customAttributes = query.getCustomDbAttributes();
        DbEntity table = this.getRootDbEntity();
        int len = customAttributes.size();
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = (DbAttribute)table.getAttribute(customAttributes.get(i));
            if (attribute == null) {
                throw new CayenneRuntimeException("Attribute does not exist: " + customAttributes.get(i));
            }
            columns.add(new ColumnDescriptor(attribute, this.getCurrentAlias()));
        }
        return columns;
    }

    private void appendColumn(List<ColumnDescriptor> columns, ObjAttribute objAttribute, DbAttribute attribute, Set<DbAttribute> skipSet, String label) {
        if (skipSet.add(attribute)) {
            ColumnDescriptor column;
            String alias = this.getCurrentAlias();
            ColumnDescriptor columnDescriptor = column = objAttribute != null ? new ColumnDescriptor(objAttribute, attribute, alias) : new ColumnDescriptor(attribute, alias);
            if (label != null) {
                column.setLabel(label);
            }
            columns.add(column);
            this.defaultAttributesByColumn.put(column, objAttribute);
        } else if (objAttribute != null) {
            for (ColumnDescriptor column : columns) {
                if (!attribute.getName().equals(column.getName())) continue;
                ObjAttribute original = this.defaultAttributesByColumn.remove(column);
                if (original == null) break;
                if (this.attributeOverrides == null) {
                    this.attributeOverrides = new HashMap<ObjAttribute, ColumnDescriptor>();
                }
                this.attributeOverrides.put(original, column);
                column.setJavaClass(Void.TYPE.getName());
                break;
            }
        }
    }

    @Override
    public void resetJoinStack() {
        this.joinStack.resetStack();
    }

    @Override
    public void dbRelationshipAdded(DbRelationship relationship, JoinType joinType, String joinSplitAlias) {
        if (relationship.isToMany()) {
            this.forcingDistinct = true;
        }
        this.joinStack.pushJoin(relationship, joinType, joinSplitAlias);
    }

    @Override
    public boolean supportsTableAliases() {
        return true;
    }
}

