/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.PrefetchProcessorJointNode;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;

class ObjectTreeResolver {
    DataContext context;
    QueryMetadata queryMetadata;
    DataRowStore cache;

    ObjectTreeResolver(DataContext context, QueryMetadata queryMetadata) {
        this.queryMetadata = queryMetadata;
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List synchronizedObjectsFromDataRows(PrefetchTreeNode tree, List mainResultRows, Map extraResultsByPath) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            DataRowStore dataRowStore = this.cache;
            synchronized (dataRowStore) {
                return this.resolveObjectTree(tree, mainResultRows, extraResultsByPath);
            }
        }
    }

    List resolveObjectTree(PrefetchTreeNode tree, List mainResultRows, Map extraResultsByPath) {
        PrefetchProcessorNode decoratedTree = new TreeBuilder(mainResultRows, extraResultsByPath).buildTree(tree);
        decoratedTree.traverse(new DisjointProcessor());
        decoratedTree.traverse(new PostProcessor());
        return decoratedTree.getObjects() != null ? decoratedTree.getObjects() : new ArrayList(1);
    }

    final class PostProcessor
    implements PrefetchProcessor {
        PostProcessor() {
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            ((PrefetchProcessorNode)node).connectToParents();
            return true;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            if (!processorNode.getObjects().isEmpty()) {
                ObjectTreeResolver.this.cache.snapshotsUpdatedForObjects(processorNode.getObjects(), processorNode.getResolvedRows());
            }
            processorNode.connectToParents();
            return true;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }
    }

    final class JointProcessor
    implements PrefetchProcessor {
        DataRow currentFlatRow;
        PrefetchProcessorNode rootNode;

        JointProcessor(PrefetchProcessorJointNode rootNode) {
            this.rootNode = rootNode;
        }

        void setCurrentFlatRow(DataRow currentFlatRow) {
            this.currentFlatRow = currentFlatRow;
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return node == this.rootNode ? this.startJointPrefetch(node) : false;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            Persistent object = null;
            Map<String, Object> id = processorNode.idFromFlatRow(this.currentFlatRow);
            object = processorNode.getResolved(id);
            if (object == null) {
                DataRow row = processorNode.rowFromFlatRow(this.currentFlatRow);
                object = processorNode.getResolver().objectFromDataRow(row);
                if (object == null) {
                    return false;
                }
                processorNode.putResolved(id, object);
                processorNode.addObject(object, row);
            }
            if (processorNode.isPartitionedByParent()) {
                PrefetchProcessorNode parent = (PrefetchProcessorNode)processorNode.getParent();
                processorNode.linkToParent(object, parent.getLastResolved());
            }
            processorNode.setLastResolved(object);
            return processorNode.isJointChildren();
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return ((PrefetchProcessorNode)node).isJointChildren();
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    final class DisjointProcessor
    implements PrefetchProcessor {
        DisjointProcessor() {
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            List objects;
            PrefetchProcessorNode processorNode = (PrefetchProcessorNode)node;
            if (processorNode.getDataRows() == null) {
                return false;
            }
            if (processorNode.getDataRows().isEmpty()) {
                return true;
            }
            if (processorNode instanceof PrefetchProcessorJointNode) {
                JointProcessor subprocessor = new JointProcessor((PrefetchProcessorJointNode)processorNode);
                Iterator it = processorNode.getDataRows().iterator();
                while (it.hasNext()) {
                    subprocessor.setCurrentFlatRow((DataRow)it.next());
                    processorNode.traverse(subprocessor);
                }
                objects = processorNode.getObjects();
                ObjectTreeResolver.this.cache.snapshotsUpdatedForObjects(objects, ((PrefetchProcessorJointNode)processorNode).getResolvedRows());
            } else if (processorNode.getIncoming() != null && processorNode.getIncoming().getRelationship().isFlattened()) {
                objects = processorNode.getResolver().relatedObjectsFromDataRows(processorNode.getDataRows(), processorNode);
                processorNode.setObjects(objects);
            } else {
                objects = processorNode.getResolver().objectsFromDataRows(processorNode.getDataRows());
                processorNode.setObjects(objects);
            }
            if (objects.isEmpty()) {
                return true;
            }
            if (processorNode.isPartitionedByParent() && !processorNode.getIncoming().getRelationship().isFlattened()) {
                ObjEntity sourceObjEntity = null;
                String relatedIdPrefix = null;
                ArcProperty reverseArc = processorNode.getIncoming().getComplimentaryReverseArc();
                if (reverseArc == null) {
                    relatedIdPrefix = processorNode.getIncoming().getRelationship().getReverseDbRelationshipPath() + ".";
                    sourceObjEntity = (ObjEntity)processorNode.getIncoming().getRelationship().getSourceEntity();
                }
                for (Persistent destinationObject : objects) {
                    Persistent sourceObject = null;
                    if (reverseArc != null) {
                        sourceObject = (Persistent)reverseArc.readProperty(destinationObject);
                    } else {
                        ObjectStore objectStore = ObjectTreeResolver.this.context.getObjectStore();
                        DataRow snapshot = objectStore.getSnapshot(destinationObject.getObjectId());
                        ObjectId id = processorNode.getResolver().createObjectId(snapshot, sourceObjEntity, relatedIdPrefix);
                        if (id == null) {
                            throw new CayenneRuntimeException("Can't build ObjectId from row: " + snapshot + ", entity: " + sourceObjEntity.getName() + ", prefix: " + relatedIdPrefix);
                        }
                        sourceObject = (Persistent)objectStore.getNode(id);
                    }
                    if (sourceObject == null || sourceObject.getPersistenceState() == 5) continue;
                    processorNode.linkToParent(destinationObject, sourceObject);
                }
            }
            return true;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    final class TreeBuilder
    implements PrefetchProcessor {
        PrefetchProcessorNode root;
        LinkedList<PrefetchProcessorNode> nodeStack;
        List mainResultRows;
        Map extraResultsByPath;

        TreeBuilder(List mainResultRows, Map extraResultsByPath) {
            this.mainResultRows = mainResultRows;
            this.extraResultsByPath = extraResultsByPath;
        }

        PrefetchProcessorNode buildTree(PrefetchTreeNode tree) {
            this.nodeStack = new LinkedList();
            this.root = null;
            tree.traverse(this);
            if (this.root == null) {
                throw new CayenneRuntimeException("Failed to create prefetch processing tree.");
            }
            return this.root;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            if (this.getParent() == null) {
                return this.startDisjointPrefetch(node);
            }
            PrefetchProcessorNode decorated = new PrefetchProcessorNode(this.getParent(), node.getName());
            decorated.setPhantom(true);
            return this.addNode(decorated);
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorNode decorated = !node.adjacentJointNodes().isEmpty() ? new PrefetchProcessorJointNode(this.getParent(), node.getName()) : new PrefetchProcessorNode(this.getParent(), node.getName());
            decorated.setPhantom(false);
            decorated.setSemantics(2);
            return this.addNode(decorated);
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode decorated = new PrefetchProcessorJointNode(this.getParent(), node.getName());
            decorated.setPhantom(false);
            decorated.setSemantics(1);
            boolean result = this.addNode(decorated);
            PrefetchProcessorNode groupNode = decorated;
            while (groupNode.getParent() != null && !groupNode.isDisjointPrefetch()) {
                groupNode = (PrefetchProcessorNode)groupNode.getParent();
                groupNode.setJointChildren(true);
            }
            return result;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            return this.startDisjointPrefetch(node);
        }

        public void finishPrefetch(PrefetchTreeNode node) {
            this.nodeStack.removeLast();
        }

        boolean addNode(PrefetchProcessorNode node) {
            ClassDescriptor descriptor;
            ArcProperty arc;
            List rows;
            PrefetchProcessorNode currentNode = this.getParent();
            if (currentNode != null) {
                rows = (List)this.extraResultsByPath.get(node.getPath());
                arc = (ArcProperty)currentNode.getResolver().getDescriptor().getProperty(node.getName());
                if (arc == null) {
                    throw new CayenneRuntimeException("No relationship with name '" + node.getName() + "' found in entity " + currentNode.getResolver().getEntity().getName());
                }
                descriptor = arc.getTargetDescriptor();
            } else {
                arc = null;
                descriptor = ObjectTreeResolver.this.queryMetadata.getClassDescriptor();
                rows = this.mainResultRows;
            }
            node.setDataRows(rows);
            node.setResolver(new ObjectResolver(ObjectTreeResolver.this.context, descriptor));
            node.setIncoming(arc);
            if (currentNode != null) {
                currentNode.addChild(node);
            }
            node.afterInit();
            if (this.nodeStack.isEmpty()) {
                this.root = node;
            }
            this.nodeStack.addLast(node);
            return true;
        }

        PrefetchProcessorNode getParent() {
            return this.nodeStack.isEmpty() ? null : this.nodeStack.getLast();
        }
    }
}

