/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQLQuery
implements Query {
    protected String name;
    protected String ejbqlStatement;
    protected Map<Object, Object> parameters;
    protected transient EJBQLCompiledExpression expression;
    EJBQLQueryMetadata metadata = new EJBQLQueryMetadata();

    public EJBQLQuery(String ejbqlStatement) {
        this.ejbqlStatement = ejbqlStatement;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.metadata.resolve(resolver, this);
        return this.metadata;
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        DataMap map = this.getMetaData(resolver).getDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap found, can't route query " + this);
        }
        router.route(router.engineForDataMap(map), this, substitutedQuery);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.ejbqlAction(this);
    }

    public String getEjbqlStatement() {
        return this.ejbqlStatement;
    }

    public EJBQLCompiledExpression getExpression(EntityResolver resolver) throws EJBQLException {
        if (this.expression == null) {
            this.expression = EJBQLParserFactory.getParser().compile(this.ejbqlStatement, resolver);
        }
        return this.expression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Object, Object> getParameters() {
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : Collections.EMPTY_MAP;
    }

    public void setParameter(String name, Object object) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Null or empty parameter name");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<Object, Object>();
        }
        this.parameters.put(name, object);
    }

    public void setParameter(int position, Object object) {
        if (position < 1) {
            throw new IllegalArgumentException("Parameter position must be >= 1: " + position);
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<Object, Object>();
        }
        this.parameters.put(position, object);
    }

    public int getFetchLimit() {
        return this.metadata.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.metadata.setFetchLimit(fetchLimit);
    }
}

