/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropRelationshipToModel
extends AbstractToModelToken.Entity {
    private DbRelationship rel;

    public DropRelationshipToModel(DbEntity entity, DbRelationship rel) {
        super(entity);
        this.rel = rel;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddRelationshipToDb(this.getEntity(), this.rel);
    }

    public void execute(MergerContext mergerContext) {
        this.remove(this.rel, true);
    }

    public String getTokenName() {
        return "Drop Relationship";
    }

    public String getTokenValue() {
        StringBuilder s = new StringBuilder();
        s.append(this.rel.getSourceEntity().getName());
        s.append("->");
        s.append(this.rel.getTargetEntityName());
        return s.toString();
    }
}

