/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.enhancer;

import org.apache.cayenne.enhancer.EmbeddableVisitor;
import org.apache.cayenne.enhancer.EnhancerVisitorFactory;
import org.apache.cayenne.jpa.enhancer.JpaAccessorVisitor;
import org.apache.cayenne.jpa.enhancer.JpaPojoVisitor;
import org.apache.cayenne.jpa.map.JpaEmbeddable;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;

public class JpaEnhancerVisitorFactory
implements EnhancerVisitorFactory {
    private JpaEntityMap entityMap;

    public JpaEnhancerVisitorFactory(JpaEntityMap entityMap) {
        this.entityMap = entityMap;
    }

    public ClassVisitor createVisitor(String className, ClassVisitor out) {
        String key = className.replace('/', '.');
        JpaEntity entity = this.entityMap.entityForClass(key);
        if (entity != null) {
            JpaPojoVisitor e1 = new JpaPojoVisitor(out, entity);
            JpaAccessorVisitor e2 = new JpaAccessorVisitor((ClassVisitor)e1, entity);
            SerialVersionUIDAdder e3 = new SerialVersionUIDAdder((ClassVisitor)e2);
            return e3;
        }
        JpaEmbeddable embeddable = this.entityMap.embeddableForClass(key);
        if (embeddable != null) {
            EmbeddableVisitor e1 = new EmbeddableVisitor(out);
            SerialVersionUIDAdder e2 = new SerialVersionUIDAdder((ClassVisitor)e1);
            return e2;
        }
        return null;
    }
}

