/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.cayenne.jpa.conf.AnnotationProcessor;
import org.apache.cayenne.jpa.conf.AnnotationProcessorFactory;
import org.apache.cayenne.jpa.conf.AnnotationProcessorStack;
import org.apache.cayenne.jpa.map.JpaAssociationOverride;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaAttributeOverride;
import org.apache.cayenne.jpa.map.JpaBasic;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.jpa.map.JpaEmbedded;
import org.apache.cayenne.jpa.map.JpaEmbeddedId;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaGeneratedValue;
import org.apache.cayenne.jpa.map.JpaId;
import org.apache.cayenne.jpa.map.JpaJoinColumn;
import org.apache.cayenne.jpa.map.JpaJoinTable;
import org.apache.cayenne.jpa.map.JpaManagedClass;
import org.apache.cayenne.jpa.map.JpaManyToMany;
import org.apache.cayenne.jpa.map.JpaManyToOne;
import org.apache.cayenne.jpa.map.JpaOneToMany;
import org.apache.cayenne.jpa.map.JpaOneToOne;
import org.apache.cayenne.jpa.map.JpaTransient;
import org.apache.cayenne.jpa.map.JpaVersion;

class MemberAnnotationProcessorFactory
extends AnnotationProcessorFactory {
    MemberAnnotationProcessorFactory() {
    }

    static final class VersionProcessor
    extends L1Processor {
        VersionProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaVersion attribute = new JpaVersion();
            managedClass.getAttributes().getVersionAttributes().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaVersion)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaVersion)) {
                context.push(pop);
            }
        }
    }

    static final class TransientProcessor
    extends L1Processor {
        TransientProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaTransient attribute = new JpaTransient();
            managedClass.getAttributes().getTransientAttributes().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaTransient)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaTransient)) {
                context.push(pop);
            }
        }
    }

    static final class TemporalProcessor
    extends L2Processor {
        TemporalProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            TemporalType value = element.getAnnotation(Temporal.class).value();
            if (attribute instanceof JpaBasic) {
                ((JpaBasic)attribute).setTemporal(value);
            } else if (attribute instanceof JpaId) {
                ((JpaId)attribute).setTemporal(value);
            } else if (attribute instanceof JpaVersion) {
                ((JpaVersion)attribute).setTemporal(value);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class OrderByProcessor
    extends L2Processor {
        OrderByProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            String order = element.getAnnotation(OrderBy.class).value();
            if (attribute instanceof JpaOneToMany) {
                ((JpaOneToMany)attribute).setOrderBy(order);
            } else if (attribute instanceof JpaManyToMany) {
                ((JpaManyToMany)attribute).setOrderBy(order);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class OneToOneProcessor
    extends L1Processor {
        OneToOneProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaOneToOne attribute = new JpaOneToOne(element.getAnnotation(OneToOne.class));
            managedClass.getAttributes().getOneToOneRelationships().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaOneToOne)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaOneToOne)) {
                context.push(pop);
            }
        }
    }

    static final class OneToManyProcessor
    extends L1Processor {
        OneToManyProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaOneToMany attribute = new JpaOneToMany(element.getAnnotation(OneToMany.class));
            managedClass.getAttributes().getOneToManyRelationships().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaOneToMany)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaOneToMany)) {
                context.push(pop);
            }
        }
    }

    static final class MapKeyProcessor
    extends L2Processor {
        MapKeyProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            String key = element.getAnnotation(MapKey.class).name();
            if (attribute instanceof JpaOneToMany) {
                ((JpaOneToMany)attribute).setMapKey(key);
            } else if (attribute instanceof JpaManyToMany) {
                ((JpaManyToMany)attribute).setMapKey(key);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class ManyToOneProcessor
    extends L1Processor {
        ManyToOneProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaManyToOne attribute = new JpaManyToOne(element.getAnnotation(ManyToOne.class));
            managedClass.getAttributes().getManyToOneRelationships().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaManyToMany)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaManyToOne)) {
                context.push(pop);
            }
        }
    }

    static final class ManyToManyProcessor
    extends L1Processor {
        ManyToManyProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaManyToMany attribute = new JpaManyToMany(element.getAnnotation(ManyToMany.class));
            managedClass.getAttributes().getManyToManyRelationships().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaManyToMany)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaManyToMany)) {
                context.push(pop);
            }
        }
    }

    static final class LobProcessor
    extends L2Processor {
        LobProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (attribute instanceof JpaBasic) {
                ((JpaBasic)attribute).setLob(true);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class JoinTableProcessor
    extends L2Processor {
        JoinTableProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaJoinTable joinTable = new JpaJoinTable(element.getAnnotation(JoinTable.class));
            if (attribute instanceof JpaOneToMany) {
                ((JpaOneToMany)attribute).setJoinTable(joinTable);
            } else if (attribute instanceof JpaOneToOne) {
                ((JpaOneToOne)attribute).setJoinTable(joinTable);
            } else if (attribute instanceof JpaManyToOne) {
                ((JpaManyToOne)attribute).setJoinTable(joinTable);
            } else if (attribute instanceof JpaManyToMany) {
                ((JpaManyToMany)attribute).setJoinTable(joinTable);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class JoinColumnsProcessor
    extends L2Processor {
        JoinColumnsProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            JoinColumn[] annotations = element.getAnnotation(JoinColumns.class).value();
            ArrayList<JpaJoinColumn> joinColumns = new ArrayList<JpaJoinColumn>(annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                joinColumns.add(new JpaJoinColumn(annotations[i]));
            }
            if (attribute instanceof JpaOneToMany) {
                ((JpaOneToMany)attribute).getJoinColumns().addAll(joinColumns);
            } else if (attribute instanceof JpaOneToOne) {
                ((JpaOneToOne)attribute).getJoinColumns().addAll(joinColumns);
            } else if (attribute instanceof JpaManyToOne) {
                ((JpaManyToOne)attribute).getJoinColumns().addAll(joinColumns);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class JoinColumnProcessor
    extends L2Processor {
        JoinColumnProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaJoinColumn joinColumn = new JpaJoinColumn(element.getAnnotation(JoinColumn.class));
            if (attribute instanceof JpaOneToMany) {
                ((JpaOneToMany)attribute).getJoinColumns().add(joinColumn);
            } else if (attribute instanceof JpaOneToOne) {
                ((JpaOneToOne)attribute).getJoinColumns().add(joinColumn);
            } else if (attribute instanceof JpaManyToOne) {
                ((JpaManyToOne)attribute).getJoinColumns().add(joinColumn);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class IdProcessor
    extends L1Processor {
        IdProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaId attribute = new JpaId();
            managedClass.getAttributes().getIds().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaId)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaId)) {
                context.push(pop);
            }
        }
    }

    static final class GeneratedValueProcessor
    extends L2Processor {
        GeneratedValueProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (attribute instanceof JpaId) {
                JpaGeneratedValue generated = new JpaGeneratedValue(element.getAnnotation(GeneratedValue.class));
                ((JpaId)attribute).setGeneratedValue(generated);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class EnumeratedProcessor
    extends L2Processor {
        EnumeratedProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (attribute instanceof JpaBasic) {
                EnumType enumType = element.getAnnotation(Enumerated.class).value();
                ((JpaBasic)attribute).setEnumerated(enumType);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class EmbeddedIdProcessor
    extends L1Processor {
        EmbeddedIdProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaEmbeddedId id = new JpaEmbeddedId();
            managedClass.getAttributes().setEmbeddedId(id);
            context.push(id);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaEmbeddedId)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaEmbeddedId)) {
                context.push(pop);
            }
        }
    }

    static final class EmbeddedProcessor
    extends L1Processor {
        EmbeddedProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaEmbedded attribute = new JpaEmbedded();
            managedClass.getAttributes().getEmbeddedAttributes().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaEmbedded)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaEmbedded)) {
                context.push(pop);
            }
        }
    }

    static final class ColumnProcessor
    extends L2Processor {
        ColumnProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaColumn column = new JpaColumn(element.getAnnotation(Column.class));
            if (attribute instanceof JpaBasic) {
                ((JpaBasic)attribute).setColumn(column);
            } else if (attribute instanceof JpaVersion) {
                ((JpaVersion)attribute).setColumn(column);
            } else if (attribute instanceof JpaId) {
                ((JpaId)attribute).setColumn(column);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class BasicProcessor
    extends L1Processor {
        BasicProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            JpaBasic attribute = new JpaBasic(element.getAnnotation(Basic.class));
            managedClass.getAttributes().getBasicAttributes().add(attribute);
            context.push(attribute);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (!(attribute instanceof JpaBasic)) {
                super.onAttribute(attribute, element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object pop = context.pop();
            if (!(pop instanceof JpaBasic)) {
                context.push(pop);
            }
        }
    }

    static final class AttributeOverridesProcessor
    extends L1Processor {
        AttributeOverridesProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (attribute instanceof JpaEmbeddedId) {
                AttributeOverrides overrides = element.getAnnotation(AttributeOverrides.class);
                for (AttributeOverride overrideAnnotation : overrides.value()) {
                    JpaAttributeOverride override = new JpaAttributeOverride(overrideAnnotation);
                    ((JpaEmbeddedId)attribute).getAttributeOverrides().add(override);
                }
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class AttributeOverrideProcessor
    extends L1Processor {
        AttributeOverrideProcessor() {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            if (attribute instanceof JpaEmbeddedId) {
                JpaAttributeOverride override = new JpaAttributeOverride(element.getAnnotation(AttributeOverride.class));
                ((JpaEmbeddedId)attribute).getAttributeOverrides().add(override);
            } else {
                super.onAttribute(attribute, element, context);
            }
        }
    }

    static final class AssociationOverridesProcessor
    extends L1Processor {
        AssociationOverridesProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            if (managedClass instanceof JpaEntity) {
                AssociationOverrides overrides = element.getAnnotation(AssociationOverrides.class);
                for (AssociationOverride overrideAnnotation : overrides.value()) {
                    JpaAssociationOverride override = new JpaAssociationOverride(overrideAnnotation);
                    ((JpaEntity)managedClass).getAssociationOverrides().add(override);
                }
            } else {
                super.onManagedClass(managedClass, element, context);
            }
        }
    }

    static final class AssociationOverrideProcessor
    extends L1Processor {
        AssociationOverrideProcessor() {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            if (managedClass instanceof JpaEntity) {
                JpaAssociationOverride override = new JpaAssociationOverride(element.getAnnotation(AssociationOverride.class));
                ((JpaEntity)managedClass).getAssociationOverrides().add(override);
            } else {
                super.onManagedClass(managedClass, element, context);
            }
        }
    }

    static abstract class L2Processor
    implements AnnotationProcessor {
        L2Processor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaAttribute attribute = null;
            Object parent = context.peek();
            attribute = parent instanceof JpaAttribute ? (JpaAttribute)parent : this.findOrCreateAttribute(element, parent, context);
            if (parent != null) {
                this.onAttribute(attribute, element, context);
            } else {
                this.recordUnsupportedAnnotation(element, context);
            }
        }

        JpaAttribute findOrCreateAttribute(AnnotatedElement element, Object parent, AnnotationProcessorStack context) {
            JpaBasic basic = null;
            if (parent instanceof JpaManagedClass) {
                JpaManagedClass managedClass = (JpaManagedClass)parent;
                String name = ((Member)((Object)element)).getName();
                basic = managedClass.getAttributes().getBasicAttribute(name);
                if (basic == null) {
                    basic = new JpaBasic();
                    context.push(basic);
                    context.pop();
                    managedClass.getAttributes().getBasicAttributes().add(basic);
                }
            }
            return basic;
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void recordUnsupportedAnnotation(AnnotatedElement element, AnnotationProcessorStack context) {
            context.recordConflict(element, AnnotationProcessorFactory.annotationClass(this.getClass()), "Unsupported in this context");
        }
    }

    static abstract class L1Processor
    implements AnnotationProcessor {
        L1Processor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object parent = context.peek();
            if (parent instanceof JpaManagedClass) {
                this.onManagedClass((JpaManagedClass)parent, element, context);
            } else if (parent instanceof JpaAttribute) {
                this.onAttribute((JpaAttribute)parent, element, context);
            } else {
                this.recordUnsupportedAnnotation(element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
        }

        void onManagedClass(JpaManagedClass managedClass, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void onAttribute(JpaAttribute attribute, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void recordUnsupportedAnnotation(AnnotatedElement element, AnnotationProcessorStack context) {
            context.recordConflict(element, AnnotationProcessorFactory.annotationClass(this.getClass()), "Unsupported in this context");
        }
    }
}

