/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.jpa.conf.AnnotationProcessor;
import org.apache.cayenne.jpa.conf.AnnotationProcessorStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AnnotationProcessorFactory {
    static final String ANNOTATIONS_PACKAGE = "javax.persistence.";
    static final String PROCESSOR_NAME_SUFFIX = "Processor";
    static final AnnotationProcessor NOOP_PROCESSOR = new AnnotationProcessor(){

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
        }
    };
    final Map<String, AnnotationProcessor> processors = new HashMap<String, AnnotationProcessor>();

    static Class<?> processorClass(Class<?> factoryClass, String annotationFQN) {
        if (annotationFQN.startsWith(ANNOTATIONS_PACKAGE)) {
            String processorName = factoryClass.getName() + "$" + annotationFQN.substring(ANNOTATIONS_PACKAGE.length()) + PROCESSOR_NAME_SUFFIX;
            try {
                return Class.forName(processorName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static Class<?> annotationClass(Class<?> processorClass) {
        String name = processorClass.getName();
        if (!name.endsWith(PROCESSOR_NAME_SUFFIX)) {
            return null;
        }
        int split = name.lastIndexOf(36);
        if (split <= 0) {
            return null;
        }
        String className = name.substring(split + 1);
        String annotationFQN = ANNOTATIONS_PACKAGE + className.substring(0, className.length() - PROCESSOR_NAME_SUFFIX.length());
        try {
            return Class.forName(annotationFQN, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    AnnotationProcessorFactory() {
    }

    AnnotationProcessor getProcessor(Annotation annotation) {
        String annotationName = annotation.annotationType().getName();
        AnnotationProcessor processor = this.processors.get(annotationName);
        if (processor == null) {
            processor = this.createProcessor(annotationName);
            this.processors.put(annotationName, processor);
        }
        return processor == NOOP_PROCESSOR ? null : processor;
    }

    AnnotationProcessor createProcessor(String annotationFQN) {
        Class<?> processorClass = AnnotationProcessorFactory.processorClass(this.getClass(), annotationFQN);
        if (processorClass != null) {
            try {
                return (AnnotationProcessor)processorClass.newInstance();
            }
            catch (Exception e) {
                return NOOP_PROCESSOR;
            }
        }
        return NOOP_PROCESSOR;
    }
}

