/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.jpa.CayenneEntityManager;
import org.apache.cayenne.jpa.JpaEJBQLQuery;
import org.apache.cayenne.jpa.JpaNamedQuery;
import org.apache.cayenne.jpa.JpaNativeQuery;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.JpaTransaction;
import org.apache.cayenne.jpa.ResourceLocalEntityManagerFactory;
import org.apache.cayenne.query.RefreshQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocalEntityManager
implements EntityManager,
CayenneEntityManager {
    protected EntityTransaction transaction;
    protected ResourceLocalEntityManagerFactory factory;
    protected FlushModeType flushMode;
    protected boolean open;
    protected ObjectContext context;

    public ResourceLocalEntityManager(ObjectContext context, ResourceLocalEntityManagerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null entity manager factory");
        }
        this.open = true;
        this.context = context;
        this.factory = factory;
    }

    @Override
    public DataChannel getChannel() {
        return this.context.getChannel();
    }

    protected ResourceLocalEntityManagerFactory getFactory() {
        return this.factory;
    }

    public void close() {
        this.checkClosed();
        if (this.transaction != null && this.transaction.isActive()) {
            throw new IllegalStateException("Active transaction in progress");
        }
        this.open = false;
    }

    public boolean isOpen() {
        return this.open && (this.factory == null || this.factory.isOpen());
    }

    public Object getDelegate() {
        return this.factory.getProvider();
    }

    public void persist(Object entity) {
        this.checkClosed();
        this.context.registerNewObject(entity);
    }

    public <T> T merge(T entity) {
        this.checkClosed();
        this.checkNotRemoved(entity);
        Persistent persistent = (Persistent)entity;
        return (T)this.context.localObject(persistent.getObjectId(), persistent);
    }

    public void remove(Object entity) {
        this.checkClosed();
        this.checkAttached(entity);
        this.context.deleteObject((Persistent)entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.checkClosed();
        return DataObjectUtils.objectForPK(this.context, entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkClosed();
        T ref = this.find(entityClass, primaryKey);
        if (ref == null) {
            throw new EntityNotFoundException("Could not find " + entityClass.toString() + " with primary key value " + primaryKey.toString());
        }
        return ref;
    }

    public void flush() {
        this.checkClosed();
        try {
            this.context.commitChanges();
        }
        catch (CayenneRuntimeException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.checkClosed();
        this.flushMode = flushMode;
    }

    public FlushModeType getFlushMode() {
        this.checkClosed();
        return this.flushMode;
    }

    public void refresh(Object entity) {
        this.checkClosed();
        Persistent p = (Persistent)entity;
        this.context.performGenericQuery(new RefreshQuery(p));
    }

    public void clear() {
        this.checkClosed();
        throw new UnsupportedOperationException("TODO");
    }

    public boolean contains(Object entity) {
        this.checkClosed();
        Persistent p = (Persistent)entity;
        return this.context.getGraphManager().getNode(p.getObjectId()) == p;
    }

    public Query createQuery(String ejbqlString) {
        this.checkClosed();
        return new JpaEJBQLQuery(this.context, ejbqlString);
    }

    public Query createNamedQuery(String name) {
        this.checkClosed();
        return new JpaNamedQuery(this.context, name);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkClosed();
        return new JpaNativeQuery(this.context, sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.createNativeQuery(sqlString, (String)null);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkClosed();
        return new JpaNativeQuery(this.context, sqlString, this.factory.getPersistenceUnitInfo().getPersistenceUnitName(), resultSetMapping);
    }

    public void joinTransaction() {
        throw new JpaProviderException("'joinTransaction' is called on a RESOURCE_LOCAL EntityManager");
    }

    public void lock(Object entity, LockModeType lockMode) {
    }

    public EntityTransaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = new JpaTransaction(this);
        }
        return this.transaction;
    }

    protected void checkAttached(Object entity) throws IllegalArgumentException {
        Persistent p = (Persistent)entity;
        if (p.getPersistenceState() == 1 || p.getObjectContext() == null) {
            throw new IllegalArgumentException("entity is detached: " + entity);
        }
    }

    protected void checkNotRemoved(Object entity) throws IllegalArgumentException {
        Persistent p = (Persistent)entity;
        if (p.getPersistenceState() == 6) {
            throw new IllegalArgumentException("entity is removed: " + entity);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("An attempt to access closed EntityManagerFactory.");
        }
    }
}

