/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBatchQuery
extends BatchQuery {
    protected List<ObjectId> objectIds;
    protected List qualifierSnapshots;
    protected List updateSnapshots;
    protected boolean usingOptimisticLocking;
    private List<DbAttribute> updatedAttributes;
    private List<DbAttribute> qualifierAttributes;
    private Collection<String> nullQualifierNames;
    private List<DbAttribute> dbAttributes;

    public UpdateBatchQuery(DbEntity dbEntity, List<DbAttribute> qualifierAttributes, List<DbAttribute> updatedAttribute, Collection<String> nullQualifierNames, int batchCapacity) {
        super(dbEntity);
        this.updatedAttributes = updatedAttribute;
        this.qualifierAttributes = qualifierAttributes;
        this.nullQualifierNames = nullQualifierNames != null ? nullQualifierNames : Collections.EMPTY_SET;
        this.qualifierSnapshots = new ArrayList(batchCapacity);
        this.updateSnapshots = new ArrayList(batchCapacity);
        this.objectIds = new ArrayList<ObjectId>(batchCapacity);
        this.dbAttributes = new ArrayList<DbAttribute>(this.updatedAttributes.size() + qualifierAttributes.size());
        this.dbAttributes.addAll(this.updatedAttributes);
        this.dbAttributes.addAll(qualifierAttributes);
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    @Override
    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    @Override
    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = this.dbAttributes.get(dbAttributeIndex);
        Object snapshot = dbAttributeIndex < this.updatedAttributes.size() ? this.updateSnapshots.get(this.batchIndex) : this.qualifierSnapshots.get(this.batchIndex);
        return this.getValue((Map)snapshot, attribute);
    }

    public void add(Map qualifierSnapshot, Map updateSnapshot) {
        this.add(qualifierSnapshot, updateSnapshot, null);
    }

    public void add(Map qualifierSnapshot, Map updateSnapshot, ObjectId id) {
        this.qualifierSnapshots.add(qualifierSnapshot);
        this.updateSnapshots.add(updateSnapshot);
        this.objectIds.add(id);
    }

    @Override
    public int size() {
        return this.qualifierSnapshots.size();
    }

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.dbAttributes;
    }

    public List<DbAttribute> getUpdatedAttributes() {
        return Collections.unmodifiableList(this.updatedAttributes);
    }

    public List<DbAttribute> getQualifierAttributes() {
        return Collections.unmodifiableList(this.qualifierAttributes);
    }

    public Map getCurrentQualifier() {
        return (Map)this.qualifierSnapshots.get(this.batchIndex);
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectIds.get(this.batchIndex);
    }
}

