/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefetchTreeNode
implements Serializable,
XMLSerializable {
    public static final int UNDEFINED_SEMANTICS = 0;
    public static final int JOINT_PREFETCH_SEMANTICS = 1;
    public static final int DISJOINT_PREFETCH_SEMANTICS = 2;
    protected String name;
    protected boolean phantom;
    protected int semantics;
    protected transient PrefetchTreeNode parent;
    protected Collection<PrefetchTreeNode> children;

    public PrefetchTreeNode() {
        this(null, null);
    }

    protected PrefetchTreeNode(PrefetchTreeNode parent, String segmentPath) {
        this.parent = parent;
        this.name = segmentPath;
        this.phantom = true;
        this.semantics = 0;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        this.traverse(new XMLEncoderOperation(encoder));
    }

    public PrefetchTreeNode getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public String getPath() {
        return this.getPath(null);
    }

    public String getPath(PrefetchTreeNode upTillParent) {
        if (this.parent == null || upTillParent == this) {
            return "";
        }
        StringBuffer path = new StringBuffer(this.getName());
        for (PrefetchTreeNode node = this.getParent(); node.getParent() != null && node != upTillParent; node = node.getParent()) {
            path.insert(0, node.getName() + ".");
        }
        return path.toString();
    }

    public Collection<PrefetchTreeNode> adjacentJointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new AdjacentJoinsOperation(c));
        return c;
    }

    public Collection<PrefetchTreeNode> jointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, false, true, false, false));
        return c;
    }

    public Collection<PrefetchTreeNode> disjointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, true, false, false, false));
        return c;
    }

    public Collection<PrefetchTreeNode> nonPhantomNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, true, true, true, false));
        return c;
    }

    public void traverse(PrefetchProcessor processor) {
        boolean result = false;
        result = this.isPhantom() ? processor.startPhantomPrefetch(this) : (this.isDisjointPrefetch() ? processor.startDisjointPrefetch(this) : (this.isJointPrefetch() ? processor.startJointPrefetch(this) : processor.startUnknownPrefetch(this)));
        if (result && this.children != null) {
            for (PrefetchTreeNode child : this.children) {
                child.traverse(processor);
            }
        }
        processor.finishPrefetch(this);
    }

    public PrefetchTreeNode getNode(String path) {
        String segment;
        PrefetchTreeNode node;
        if (Util.isEmptyString(path)) {
            throw new IllegalArgumentException("Empty path: " + path);
        }
        StringTokenizer toks = new StringTokenizer(path, ".");
        for (node = this; toks.hasMoreTokens() && node != null; node = node.getChild(segment)) {
            segment = toks.nextToken();
        }
        return node;
    }

    public PrefetchTreeNode addPath(String path) {
        if (Util.isEmptyString(path)) {
            throw new IllegalArgumentException("Empty path: " + path);
        }
        PrefetchTreeNode node = this;
        StringTokenizer toks = new StringTokenizer(path, ".");
        while (toks.hasMoreTokens()) {
            String segment = toks.nextToken();
            PrefetchTreeNode child = node.getChild(segment);
            if (child == null) {
                child = new PrefetchTreeNode(node, segment);
                node.addChild(child);
            }
            node = child;
        }
        return node;
    }

    public void removePath(String path) {
        PrefetchTreeNode node = this.getNode(path);
        while (node != null) {
            if (node.children != null) {
                node.setPhantom(true);
                break;
            }
            String segment = node.getName();
            if ((node = node.getParent()) == null) continue;
            node.removeChild(segment);
        }
    }

    public void addChild(PrefetchTreeNode child) {
        if (Util.isEmptyString(child.getName())) {
            throw new IllegalArgumentException("Child has no segmentPath: " + child);
        }
        if (child.getParent() != this) {
            child.getParent().removeChild(child.getName());
            child.parent = this;
        }
        if (this.children == null) {
            this.children = new ArrayList<PrefetchTreeNode>(4);
        }
        this.children.add(child);
    }

    public void removeChild(PrefetchTreeNode child) {
        if (this.children != null && child != null) {
            this.children.remove(child);
            child.parent = null;
        }
    }

    protected void removeChild(String segment) {
        PrefetchTreeNode child;
        if (this.children != null && (child = this.getChild(segment)) != null) {
            this.children.remove(child);
            child.parent = null;
        }
    }

    protected PrefetchTreeNode getChild(String segment) {
        if (this.children != null) {
            for (PrefetchTreeNode child : this.children) {
                if (!segment.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public PrefetchTreeNode getParent() {
        return this.parent;
    }

    public Collection<PrefetchTreeNode> getChildren() {
        return this.children == null ? Collections.EMPTY_SET : Collections.unmodifiableCollection(this.children);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public int getSemantics() {
        return this.semantics;
    }

    public void setSemantics(int semantics) {
        this.semantics = semantics;
    }

    public boolean isJointPrefetch() {
        return this.semantics == 1;
    }

    public boolean isDisjointPrefetch() {
        return this.semantics == 2;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.hasChildren()) {
            for (PrefetchTreeNode child : this.children) {
                child.parent = this;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AdjacentJoinsOperation
    implements PrefetchProcessor {
        Collection<PrefetchTreeNode> nodes;

        AdjacentJoinsOperation(Collection<PrefetchTreeNode> nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return node == PrefetchTreeNode.this;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            if (node != PrefetchTreeNode.this) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            return node == PrefetchTreeNode.this;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CollectionBuilderOperation
    implements PrefetchProcessor {
        Collection<PrefetchTreeNode> nodes;
        boolean includePhantom;
        boolean includeDisjoint;
        boolean includeJoint;
        boolean includeUnknown;

        CollectionBuilderOperation(Collection<PrefetchTreeNode> nodes, boolean includeDisjoint, boolean includeJoint, boolean includeUnknown, boolean includePhantom) {
            this.nodes = nodes;
            this.includeDisjoint = includeDisjoint;
            this.includeJoint = includeJoint;
            this.includeUnknown = includeUnknown;
            this.includePhantom = includePhantom;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            if (this.includePhantom) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            if (this.includeDisjoint) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            if (this.includeJoint) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            if (this.includeUnknown) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    class XMLEncoderOperation
    implements PrefetchProcessor {
        XMLEncoder encoder;

        XMLEncoderOperation(XMLEncoder encoder) {
            this.encoder = encoder;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            this.encoder.print("<prefetch type=\"disjoint\">");
            this.encoder.print(node.getPath());
            this.encoder.println("</prefetch>");
            return true;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            this.encoder.print("<prefetch type=\"joint\">");
            this.encoder.print(node.getPath());
            this.encoder.println("</prefetch>");
            return true;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            this.encoder.print("<prefetch>");
            this.encoder.print(node.getPath());
            this.encoder.println("</prefetch>");
            return true;
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }
}

