/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.util.Util;

public abstract class ProjectFile {
    protected String location;
    protected File tempFile;
    protected Project projectObj;

    public ProjectFile() {
    }

    public ProjectFile(Project project, String location) {
        this.location = location;
        this.projectObj = project;
    }

    public String getLocation() {
        String oName = this.getObjectName();
        if (oName == null) {
            throw new NullPointerException("Null name.");
        }
        return oName + this.getLocationSuffix();
    }

    public String getOldLocation() {
        return this.location;
    }

    public String getLocationSuffix() {
        return "";
    }

    public abstract Object getObject();

    public abstract String getObjectName();

    public abstract void save(PrintWriter var1) throws Exception;

    public abstract boolean canHandle(Object var1);

    public boolean canHandleObject() {
        return this.canHandle(this.getObject());
    }

    public void synchronizeLocation() {
        this.location = this.getLocation();
    }

    public void willSave() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemp() throws Exception {
        if (this.tempFile != null && this.tempFile.isFile()) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        File finalFile = this.resolveFile();
        this.checkWritePermissions(finalFile);
        this.tempFile = this.tempFileForFile(finalFile);
        FileOutputStream fout = new FileOutputStream(this.tempFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fout, "UTF-8");
        try {
            PrintWriter pw = new PrintWriter(fw);
            try {
                this.save(pw);
            }
            finally {
                pw.close();
            }
        }
        finally {
            fw.close();
        }
    }

    public File resolveFile() {
        return this.getProject().resolveFile(this.getLocation());
    }

    public File resolveOldFile() {
        String oldLocation = this.getOldLocation();
        return oldLocation != null ? this.getProject().resolveFile(oldLocation) : null;
    }

    public File saveCommit() throws ProjectException {
        File finalFile = this.resolveFile();
        if (this.tempFile != null) {
            if (finalFile.exists() && !finalFile.delete()) {
                throw new ProjectException("Unable to remove old master file : " + finalFile);
            }
            if (!this.tempFile.renameTo(finalFile)) {
                throw new ProjectException("Unable to move " + this.tempFile + " to " + finalFile);
            }
            this.tempFile = null;
        }
        return finalFile;
    }

    public void saveUndo() {
        if (this.tempFile != null && this.tempFile.isFile()) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    public Project getProject() {
        return this.projectObj;
    }

    public boolean isRenamed() {
        return !Util.nullSafeEquals(this.location, this.getLocation());
    }

    protected File tempFileForFile(File f) throws IOException {
        File parent = f.getParentFile();
        String name = f.getName();
        if (name == null || name.length() < 3) {
            name = "cayenne-project";
        }
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Error creating directory tree: " + parent);
        }
        return File.createTempFile(name, null, parent);
    }

    protected void checkWritePermissions(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Target file is a directory: " + file);
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Can't write to file: " + file);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProjectFile [").append(this.getClass().getName()).append("]: name = ");
        if (this.getObject() != null) {
            buf.append("*null*");
        } else {
            buf.append(this.getObjectName());
        }
        return buf.toString();
    }
}

