/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

public abstract class NamedObjectFactory {
    private static final Map factories = new HashMap();

    public static String createName(Class objectClass, Object namingContext) {
        return ((NamedObjectFactory)factories.get(objectClass)).makeName(namingContext);
    }

    public static String createName(Class objectClass, Object namingContext, String nameBase) {
        return ((NamedObjectFactory)factories.get(objectClass)).makeName(namingContext, nameBase);
    }

    public static Object createObject(Class objectClass, Object namingContext) {
        return ((NamedObjectFactory)factories.get(objectClass)).makeObject(namingContext);
    }

    public static Object createObject(Class objectClass, Object namingContext, String nameBase) {
        return ((NamedObjectFactory)factories.get(objectClass)).makeObject(namingContext, nameBase);
    }

    public static Relationship createRelationship(Entity srcEnt, Entity targetEnt, boolean toMany) {
        ObjRelationshipFactory factory = srcEnt instanceof ObjEntity ? new ObjRelationshipFactory(targetEnt, toMany) : new DbRelationshipFactory(targetEnt, toMany);
        return (Relationship)factory.makeObject(srcEnt);
    }

    protected synchronized String makeName(Object namingContext) {
        return this.makeName(namingContext, this.nameBase());
    }

    protected synchronized String makeName(Object namingContext, String nameBase) {
        int c = 1;
        String name = nameBase;
        while (this.isNameInUse(name, namingContext)) {
            name = nameBase + c++;
        }
        return name;
    }

    protected Object makeObject(Object namingContext) {
        return this.makeObject(namingContext, this.nameBase());
    }

    protected Object makeObject(Object namingContext, String nameBase) {
        return this.create(this.makeName(namingContext, nameBase), namingContext);
    }

    protected abstract String nameBase();

    protected abstract Object create(String var1, Object var2);

    protected abstract boolean isNameInUse(String var1, Object var2);

    static {
        factories.put(DataMap.class, new DataMapFactory());
        factories.put(ObjEntity.class, new ObjEntityFactory());
        factories.put(DbEntity.class, new DbEntityFactory());
        factories.put(ObjAttribute.class, new ObjAttributeFactory());
        factories.put(DbAttribute.class, new DbAttributeFactory());
        factories.put(DataNode.class, new DataNodeFactory());
        factories.put(DbRelationship.class, new DbRelationshipFactory(null, false));
        factories.put(ObjRelationship.class, new ObjRelationshipFactory(null, false));
        factories.put(DataDomain.class, new DataDomainFactory());
        factories.put(Procedure.class, new ProcedureFactory());
        factories.put(Query.class, new SelectQueryFactory());
        factories.put(ProcedureParameter.class, new ProcedureParameterFactory());
    }

    static class DbRelationshipFactory
    extends ObjRelationshipFactory {
        public DbRelationshipFactory(Entity target, boolean toMany) {
            super(target, toMany);
        }

        protected Object create(String name, Object namingContext) {
            return new DbRelationship(name);
        }

        protected String nameBase() {
            if (this.target == null) {
                return "untitledRel";
            }
            String name = this.target.getName();
            return this.toMany ? name + "_ARRAY" : "TO_" + name;
        }
    }

    static class ObjRelationshipFactory
    extends NamedObjectFactory {
        protected Entity target;
        protected boolean toMany;

        public ObjRelationshipFactory(Entity target, boolean toMany) {
            this.target = target;
            this.toMany = toMany;
        }

        protected Object create(String name, Object namingContext) {
            return new ObjRelationship(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            Entity ent = (Entity)namingContext;
            return ent.getRelationship(name) != null;
        }

        protected String nameBase() {
            if (this.target == null) {
                return "untitledRel";
            }
            String name = this.target.getName();
            return this.toMany ? Character.toLowerCase(name.charAt(0)) + name.substring(1) + "Array" : "to" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
    }

    static class DataNodeFactory
    extends NamedObjectFactory {
        DataNodeFactory() {
        }

        protected String nameBase() {
            return "UntitledDataNode";
        }

        protected Object create(String name, Object namingContext) {
            return new DataNode(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            DataDomain domain = (DataDomain)namingContext;
            return domain.getNode(name) != null;
        }
    }

    static class DbAttributeFactory
    extends ObjAttributeFactory {
        DbAttributeFactory() {
        }

        protected Object create(String name, Object namingContext) {
            return new DbAttribute(name, Integer.MAX_VALUE, (DbEntity)namingContext);
        }
    }

    static class ObjAttributeFactory
    extends NamedObjectFactory {
        ObjAttributeFactory() {
        }

        protected String nameBase() {
            return "untitledAttr";
        }

        protected Object create(String name, Object namingContext) {
            return new ObjAttribute(name, null, (ObjEntity)namingContext);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            Entity ent = (Entity)namingContext;
            return ent.getAttribute(name) != null;
        }
    }

    static class SelectQueryFactory
    extends NamedObjectFactory {
        SelectQueryFactory() {
        }

        protected String nameBase() {
            return "UntitledQuery";
        }

        protected Object create(String name, Object namingContext) {
            SelectQuery query = new SelectQuery();
            query.setName(name);
            return query;
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            DataMap map = (DataMap)namingContext;
            return map.getQuery(name) != null;
        }
    }

    static class ProcedureFactory
    extends NamedObjectFactory {
        ProcedureFactory() {
        }

        protected String nameBase() {
            return "UntitledProcedure";
        }

        protected Object create(String name, Object namingContext) {
            return new Procedure(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            DataMap map = (DataMap)namingContext;
            return map.getProcedure(name) != null;
        }
    }

    static class ProcedureParameterFactory
    extends NamedObjectFactory {
        ProcedureParameterFactory() {
        }

        protected String nameBase() {
            return "UntitledProcedureParameter";
        }

        protected Object create(String name, Object namingContext) {
            return new ProcedureParameter(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            Procedure procedure = (Procedure)namingContext;
            for (ProcedureParameter parameter : procedure.getCallParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return true;
            }
            return false;
        }
    }

    static class DbEntityFactory
    extends NamedObjectFactory {
        DbEntityFactory() {
        }

        protected String nameBase() {
            return "UntitledDbEntity";
        }

        protected Object create(String name, Object namingContext) {
            return new DbEntity(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            DataMap map = (DataMap)namingContext;
            return map.getDbEntity(name) != null;
        }
    }

    static class ObjEntityFactory
    extends NamedObjectFactory {
        ObjEntityFactory() {
        }

        protected String nameBase() {
            return "UntitledObjEntity";
        }

        protected Object create(String name, Object namingContext) {
            return new ObjEntity(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            DataMap map = (DataMap)namingContext;
            return map.getObjEntity(name) != null;
        }
    }

    static class DataMapFactory
    extends NamedObjectFactory {
        DataMapFactory() {
        }

        protected String nameBase() {
            return "UntitledMap";
        }

        protected Object create(String name, Object namingContext) {
            return new DataMap(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            if (namingContext == null) {
                return false;
            }
            DataDomain domain = (DataDomain)namingContext;
            return domain.getMap(name) != null;
        }
    }

    static class DataDomainFactory
    extends NamedObjectFactory {
        DataDomainFactory() {
        }

        protected String nameBase() {
            return "UntitledDomain";
        }

        protected Object create(String name, Object namingContext) {
            return new DataDomain(name);
        }

        protected boolean isNameInUse(String name, Object namingContext) {
            Configuration config = (Configuration)namingContext;
            return config.getDomain(name) != null;
        }
    }
}

