/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNotNullToDb
extends AbstractToDbToken {
    private DbEntity entity;
    private DbAttribute column;

    public SetNotNullToDb(DbEntity entity, DbAttribute column) {
        this.entity = entity;
        this.column = column;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(this.entity.getFullyQualifiedName());
        sqlBuffer.append(" ALTER COLUMN ");
        sqlBuffer.append(this.column.getName());
        sqlBuffer.append(" SET NOT NULL");
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Set Not Null";
    }

    @Override
    public String getTokenValue() {
        return this.entity.getName() + "." + this.column.getName();
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetAllowNullToModel(this.entity, this.column);
    }
}

