/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropTableToModel
extends AbstractToModelToken {
    private DbEntity entity;

    public DropTableToModel(DbEntity entity) {
        this.entity = entity;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createCreateTableToDb(this.entity);
    }

    public void execute(MergerContext mergerContext) {
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(this.entity)) {
            objEntity.getDataMap().removeObjEntity(objEntity.getName(), true);
        }
        this.entity.getDataMap().removeDbEntity(this.entity.getName(), true);
    }

    public String getTokenName() {
        return "Drop Table";
    }

    public String getTokenValue() {
        return this.entity.getName();
    }
}

