/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class AddColumnToModel
extends AbstractToModelToken {
    private DbEntity entity;
    private DbAttribute column;

    public AddColumnToModel(DbEntity entity, DbAttribute column) {
        this.entity = entity;
        this.column = column;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropColumToDb(this.entity, this.column);
    }

    public void execute(MergerContext mergerContext) {
        this.entity.addAttribute(this.column);
        this.synchronizeWithObjEntity(this.entity);
    }

    public String getTokenName() {
        return "Add Column";
    }

    public String getTokenValue() {
        return this.entity.getName() + "." + this.column.getName();
    }
}

