/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.util.EntityMergeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToModelToken
implements MergerToken {
    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_MODEL;
    }

    protected void synchronizeWithObjEntity(DbEntity entity) {
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(entity)) {
            new EntityMergeSupport(objEntity.getDataMap()).synchronizeWithDbEntity(objEntity);
        }
    }

    protected Collection<ObjEntity> objEntitiesMappedToDbEntity(DbEntity entity) {
        HashSet<ObjEntity> objEntities = new HashSet<ObjEntity>();
        MappingNamespace mns = entity.getDataMap().getNamespace();
        for (ObjEntity objEntity : mns.getObjEntities()) {
            if (objEntity.getDbEntity() == null || !objEntity.getDbEntity().equals(entity)) continue;
            objEntities.add(objEntity);
        }
        return objEntities;
    }

    public String toString() {
        StringBuilder ts = new StringBuilder();
        ts.append(this.getTokenName());
        ts.append(' ');
        ts.append(this.getTokenValue());
        ts.append(' ');
        ts.append(this.getDirection());
        return ts.toString();
    }
}

