/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    public static final String PATH_SEPARATOR = ".";
    protected String name;
    protected DataMap dataMap;
    protected SortedMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
    protected SortedMap<String, Relationship> relationships = new TreeMap<String, Relationship>();

    public Entity() {
        this(null);
    }

    public Entity(String name) {
        this.setName(name);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getParent() {
        return this.getDataMap();
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof DataMap)) {
            throw new IllegalArgumentException("Expected null or DataMap, got: " + parent);
        }
        this.setDataMap((DataMap)parent);
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public Attribute getAttribute(String attributeName) {
        return (Attribute)this.attributes.get(attributeName);
    }

    public void addAttribute(Attribute attribute) {
        if (attribute.getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed attribute.");
        }
        Object existingAttribute = this.attributes.get(attribute.getName());
        if (existingAttribute != null) {
            if (existingAttribute == attribute) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override attribute '" + attribute.getName() + "'");
        }
        Object existingRelationship = this.relationships.get(attribute.getName());
        if (existingRelationship != null) {
            throw new IllegalArgumentException("Attribute name conflict with existing relationship '" + attribute.getName() + "'");
        }
        this.attributes.put(attribute.getName(), attribute);
        attribute.setEntity(this);
    }

    public void removeAttribute(String attrName) {
        this.attributes.remove(attrName);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Relationship getRelationship(String relName) {
        return (Relationship)this.relationships.get(relName);
    }

    public void addRelationship(Relationship relationship) {
        if (relationship.getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed relationship.");
        }
        Object existingRelationship = this.relationships.get(relationship.getName());
        if (existingRelationship != null) {
            if (existingRelationship == relationship) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override relationship '" + relationship.getName() + "'");
        }
        Object existingAttribute = this.attributes.get(relationship.getName());
        if (existingAttribute != null) {
            throw new IllegalArgumentException("Relationship name conflict with existing attribute '" + relationship.getName() + "'");
        }
        this.relationships.put(relationship.getName(), relationship);
        relationship.setSourceEntity(this);
    }

    public void removeRelationship(String relName) {
        this.relationships.remove(relName);
    }

    public void clearRelationships() {
        this.relationships.clear();
    }

    public SortedMap<String, ? extends Relationship> getRelationshipMap() {
        return Collections.unmodifiableSortedMap(this.relationships);
    }

    public Relationship getAnyRelationship(Entity targetEntity) {
        if (this.getRelationships().isEmpty()) {
            return null;
        }
        for (Relationship relationship : this.getRelationships()) {
            if (relationship.getTargetEntity() != targetEntity) continue;
            return relationship;
        }
        return null;
    }

    public Collection<? extends Relationship> getRelationships() {
        return Collections.unmodifiableCollection(this.relationships.values());
    }

    public SortedMap<String, ? extends Attribute> getAttributeMap() {
        return Collections.unmodifiableSortedMap(this.attributes);
    }

    public Collection<? extends Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public abstract Expression translateToRelatedEntity(Expression var1, String var2);

    public Object lastPathComponent(Expression pathExp) {
        CayenneMapEntry last = null;
        Iterator<CayenneMapEntry> it = this.resolvePathComponents(pathExp);
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public abstract Iterator<CayenneMapEntry> resolvePathComponents(Expression var1) throws ExpressionException;

    public Iterator<CayenneMapEntry> resolvePathComponents(String path) throws ExpressionException {
        return new PathIterator(path);
    }

    final MappingNamespace getNonNullNamespace() {
        DataMap parent = this.getDataMap();
        if (parent == null) {
            throw new CayenneRuntimeException("Entity '" + this.getName() + "' has no parent MappingNamespace (such as DataMap)");
        }
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PathIterator
    implements Iterator<CayenneMapEntry> {
        private StringTokenizer toks;
        private Entity currentEnt;
        private String path;

        PathIterator(String path) {
            this.currentEnt = Entity.this;
            this.toks = new StringTokenizer(path, Entity.PATH_SEPARATOR);
            this.path = path;
        }

        @Override
        public boolean hasNext() {
            return this.toks.hasMoreTokens();
        }

        @Override
        public CayenneMapEntry next() {
            String pathComp = this.toks.nextToken();
            Attribute attr = this.currentEnt.getAttribute(pathComp);
            if (attr != null) {
                if (this.toks.hasMoreTokens()) {
                    throw new ExpressionException("Attribute must be the last component of the path: '" + pathComp + "'.", this.path, null);
                }
                return attr;
            }
            Relationship rel = this.currentEnt.getRelationship(pathComp);
            if (rel != null) {
                this.currentEnt = rel.getTargetEntity();
                return rel;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("Can't resolve path component: [").append(this.currentEnt.getName()).append('.').append(pathComp).append("].");
            throw new ExpressionException(buf.toString(), this.path, null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("'remove' operation is not supported.");
        }
    }
}

