/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import org.apache.cayenne.jpa.map.JpaCascade;
import org.apache.cayenne.jpa.map.JpaJoinColumn;
import org.apache.cayenne.jpa.map.JpaJoinTable;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaRelationship;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaOneToOne
extends JpaRelationship {
    protected String mappedBy;
    protected boolean optional;
    protected Collection<JpaPrimaryKeyJoinColumn> primaryKeyJoinColumns;
    protected Collection<JpaJoinColumn> joinColumns;
    protected JpaJoinTable joinTable;

    public JpaOneToOne() {
    }

    public JpaOneToOne(OneToOne annotation) {
        if (!Void.TYPE.equals(annotation.targetEntity())) {
            this.targetEntityName = annotation.targetEntity().getName();
        }
        for (int i = 0; i < annotation.cascade().length; ++i) {
            if (this.cascade == null) {
                this.cascade = new JpaCascade();
            }
            this.cascade.getCascades().add(annotation.cascade()[i]);
        }
        this.fetch = annotation.fetch();
        this.optional = annotation.optional();
        this.mappedBy = annotation.mappedBy();
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<one-to-one");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.targetEntityName != null) {
            encoder.print(" target-entity=\"" + this.targetEntityName + "\"");
        }
        if (this.fetch != null && this.fetch != FetchType.EAGER) {
            encoder.print(" fetch=\"" + this.fetch.name() + "\"");
        }
        if (!this.optional) {
            encoder.print(" optional=\"false\"");
        }
        if (this.mappedBy != null) {
            encoder.print(" mapped-by=\"" + this.mappedBy + "\"");
        }
        encoder.println('>');
        encoder.indent(1);
        for (JpaPrimaryKeyJoinColumn jpaPrimaryKeyJoinColumn : this.getPrimaryKeyJoinColumns()) {
            jpaPrimaryKeyJoinColumn.encodeAsXML(encoder);
        }
        for (JpaJoinColumn jpaJoinColumn : this.getJoinColumns()) {
            jpaJoinColumn.encodeAsXML(encoder);
        }
        if (this.joinTable != null) {
            this.joinTable.encodeAsXML(encoder);
        }
        if (this.cascade != null) {
            this.cascade.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</one-to-one>");
    }

    @Override
    public boolean isToMany() {
        return false;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    @TreeNodeChild(type=JpaPrimaryKeyJoinColumn.class)
    public Collection<JpaPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        if (this.primaryKeyJoinColumns == null) {
            this.primaryKeyJoinColumns = new ArrayList<JpaPrimaryKeyJoinColumn>();
        }
        return this.primaryKeyJoinColumns;
    }

    @TreeNodeChild(type=JpaJoinColumn.class)
    public Collection<JpaJoinColumn> getJoinColumns() {
        if (this.joinColumns == null) {
            this.joinColumns = new ArrayList<JpaJoinColumn>();
        }
        return this.joinColumns;
    }

    public JpaJoinTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(JpaJoinTable joinTable) {
        this.joinTable = joinTable;
    }
}

