/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.bridge;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import javax.persistence.InheritanceType;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.bridge.JpaDbRelationship;
import org.apache.cayenne.jpa.bridge.JpaEjbQLQuery;
import org.apache.cayenne.jpa.bridge.JpaIndirectQuery;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaAttributeOverride;
import org.apache.cayenne.jpa.map.JpaAttributes;
import org.apache.cayenne.jpa.map.JpaBasic;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.jpa.map.JpaDiscriminatorColumn;
import org.apache.cayenne.jpa.map.JpaEmbeddable;
import org.apache.cayenne.jpa.map.JpaEmbedded;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaEntityListener;
import org.apache.cayenne.jpa.map.JpaEntityListeners;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.jpa.map.JpaId;
import org.apache.cayenne.jpa.map.JpaJoinColumn;
import org.apache.cayenne.jpa.map.JpaManagedClass;
import org.apache.cayenne.jpa.map.JpaManyToMany;
import org.apache.cayenne.jpa.map.JpaManyToOne;
import org.apache.cayenne.jpa.map.JpaNamedQuery;
import org.apache.cayenne.jpa.map.JpaOneToMany;
import org.apache.cayenne.jpa.map.JpaOneToOne;
import org.apache.cayenne.jpa.map.JpaPersistenceUnitDefaults;
import org.apache.cayenne.jpa.map.JpaPersistenceUnitMetadata;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaQueryHint;
import org.apache.cayenne.jpa.map.JpaRelationship;
import org.apache.cayenne.jpa.map.JpaSecondaryTable;
import org.apache.cayenne.jpa.map.JpaTable;
import org.apache.cayenne.jpa.map.JpaVersion;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.BaseTreeVisitor;
import org.apache.cayenne.util.HierarchicalTreeVisitor;
import org.apache.cayenne.util.TraversalUtil;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.SimpleValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMapConverter {
    protected EntityMapLoaderContext context;
    protected ProjectPath targetPath;
    protected HierarchicalTreeVisitor visitor;

    public synchronized DataMap toDataMap(String name, EntityMapLoaderContext context) {
        this.context = context;
        DataMap dataMap = new DataMap(name);
        dataMap.setDefaultPackage(context.getEntityMap().getPackageName());
        dataMap.setDefaultSchema(context.getEntityMap().getSchema());
        this.targetPath = new ProjectPath(dataMap);
        if (this.visitor == null) {
            this.visitor = this.createVisitor();
        }
        TraversalUtil.traverse(context.getEntityMap(), this.visitor);
        this.postprocess(dataMap);
        return dataMap;
    }

    protected void postprocess(DataMap dataMap) {
        for (DbEntity entity : dataMap.getDbEntities()) {
            for (JpaDbRelationship jpaDbRelationship : entity.getRelationships()) {
                DbRelationship owner;
                if (jpaDbRelationship.getMappedBy() == null || (owner = (DbRelationship)jpaDbRelationship.getTargetEntity().getRelationship(jpaDbRelationship.getMappedBy())) == null) continue;
                for (DbJoin join : owner.getJoins()) {
                    DbJoin reverse = join.createReverseJoin();
                    reverse.setRelationship(jpaDbRelationship);
                    jpaDbRelationship.addJoin(reverse);
                }
            }
        }
    }

    protected void recordConflict(ProjectPath path, String message) {
        this.context.recordConflict(new SimpleValidationFailure(path.getObject(), message));
    }

    protected HierarchicalTreeVisitor createVisitor() {
        BaseTreeVisitor listenersVisitor = new BaseTreeVisitor();
        listenersVisitor.addChildVisitor(JpaEntityListener.class, new JpaDefaultEntityListenerVisitor());
        BaseTreeVisitor defaultsVisitor = new BaseTreeVisitor();
        defaultsVisitor.addChildVisitor(JpaEntityListeners.class, listenersVisitor);
        BaseTreeVisitor metadataVisitor = new BaseTreeVisitor();
        metadataVisitor.addChildVisitor(JpaPersistenceUnitDefaults.class, defaultsVisitor);
        BaseTreeVisitor visitor = new BaseTreeVisitor();
        visitor.addChildVisitor(JpaEntity.class, new JpaEntityVisitor());
        visitor.addChildVisitor(JpaEmbeddable.class, new JpaEmbeddableVisitor());
        visitor.addChildVisitor(JpaNamedQuery.class, new JpaNamedQueryVisitor());
        visitor.addChildVisitor(JpaPersistenceUnitMetadata.class, metadataVisitor);
        return visitor;
    }

    private void createDbAttribute(String tableName, JpaColumn column, JpaAttribute attribute) {
        DataMap dataMap;
        DbEntity entity;
        DbAttribute dbAttribute = new DbAttribute(column.getName());
        if (attribute instanceof JpaBasic) {
            JpaBasic basic = (JpaBasic)attribute;
            dbAttribute.setType(basic.getDefaultJdbcType());
        } else if (attribute instanceof JpaVersion) {
            JpaVersion version = (JpaVersion)attribute;
            dbAttribute.setType(version.getDefaultJdbcType());
        }
        dbAttribute.setMandatory(!column.isNullable());
        dbAttribute.setMaxLength(column.getLength());
        if (column.getScale() > 0) {
            dbAttribute.setScale(column.getScale());
        }
        if (column.getPrecision() > 0) {
            dbAttribute.setAttributePrecision(column.getPrecision());
        }
        if ((entity = (dataMap = this.targetPath.firstInstanceOf(DataMap.class)).getDbEntity(tableName)) == null) {
            entity = new DbEntity(tableName);
            dataMap.addDbEntity(entity);
        }
        entity.addAttribute(dbAttribute);
    }

    private String getSecondaryTableDbRelationshipName(String secondaryTableName) {
        return "$cay_secondary_" + secondaryTableName;
    }

    private EntityListener makeEntityListener(JpaEntityListener jpaListener) {
        EntityListener listener = new EntityListener(jpaListener.getClassName());
        if (jpaListener.getPostLoad() != null) {
            listener.getCallbackMap().getPostLoad().addCallbackMethod(jpaListener.getPostLoad().getMethodName());
        }
        if (jpaListener.getPostPersist() != null) {
            listener.getCallbackMap().getPostPersist().addCallbackMethod(jpaListener.getPostPersist().getMethodName());
        }
        if (jpaListener.getPostRemove() != null) {
            listener.getCallbackMap().getPostRemove().addCallbackMethod(jpaListener.getPostRemove().getMethodName());
        }
        if (jpaListener.getPostUpdate() != null) {
            listener.getCallbackMap().getPostUpdate().addCallbackMethod(jpaListener.getPostUpdate().getMethodName());
        }
        if (jpaListener.getPrePersist() != null) {
            listener.getCallbackMap().getPrePersist().addCallbackMethod(jpaListener.getPrePersist().getMethodName());
        }
        if (jpaListener.getPreRemove() != null) {
            listener.getCallbackMap().getPreRemove().addCallbackMethod(jpaListener.getPreRemove().getMethodName());
        }
        if (jpaListener.getPreUpdate() != null) {
            listener.getCallbackMap().getPreUpdate().addCallbackMethod(jpaListener.getPreUpdate().getMethodName());
        }
        return listener;
    }

    Field lookupFieldInHierarchy(Class<?> beanClass, String fieldName) throws SecurityException, NoSuchFieldException {
        try {
            return beanClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = beanClass.getSuperclass();
            if (superClass == null || superClass.getName().equals(Object.class.getName())) {
                throw e;
            }
            return this.lookupFieldInHierarchy(superClass, fieldName);
        }
    }

    abstract class NestedVisitor
    extends BaseTreeVisitor {
        NestedVisitor() {
        }

        abstract Object createObject(ProjectPath var1);

        public boolean onStartNode(ProjectPath path) {
            Object object = this.createObject(path);
            if (object != null) {
                DataMapConverter.this.targetPath = DataMapConverter.this.targetPath.appendToPath(object);
                return true;
            }
            return false;
        }

        public void onFinishNode(ProjectPath path) {
            DataMapConverter.this.targetPath = DataMapConverter.this.targetPath.subpathWithSize(DataMapConverter.this.targetPath.getPath().length - 1);
        }
    }

    class JpaSecondaryTableVisitor
    extends NestedVisitor {
        JpaSecondaryTableVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaSecondaryTable jpaTable = (JpaSecondaryTable)path.getObject();
            ObjEntity parentCayenneEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            DbEntity secondaryEntity = parentCayenneEntity.getDataMap().getDbEntity(jpaTable.getName());
            if (secondaryEntity == null) {
                secondaryEntity = new DbEntity(jpaTable.getName());
                parentCayenneEntity.getDataMap().addDbEntity(secondaryEntity);
            }
            secondaryEntity.setCatalog(jpaTable.getCatalog());
            secondaryEntity.setSchema(jpaTable.getSchema());
            return secondaryEntity;
        }
    }

    class JpaTableVisitor
    extends NestedVisitor {
        JpaTableVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaTable jpaTable = (JpaTable)path.getObject();
            ObjEntity parentCayenneEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            DbEntity cayenneEntity = parentCayenneEntity.getDataMap().getDbEntity(jpaTable.getName());
            if (cayenneEntity == null) {
                cayenneEntity = new DbEntity(jpaTable.getName());
                parentCayenneEntity.getDataMap().addDbEntity(cayenneEntity);
            }
            cayenneEntity.setCatalog(jpaTable.getCatalog());
            cayenneEntity.setSchema(jpaTable.getSchema());
            parentCayenneEntity.setDbEntity(cayenneEntity);
            return cayenneEntity;
        }
    }

    class JpaNamedQueryVisitor
    extends NestedVisitor {
        JpaNamedQueryVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaIndirectQuery cayenneQuery;
            JpaNamedQuery jpaQuery = (JpaNamedQuery)path.getObject();
            JpaQueryHint hint = jpaQuery.getHint("cayenne.query.type");
            if (hint != null && !Util.isEmptyString(hint.getValue())) {
                try {
                    Class<?> cayenneQueryClass = Class.forName(hint.getValue(), true, Thread.currentThread().getContextClassLoader());
                    if (!JpaIndirectQuery.class.isAssignableFrom(cayenneQueryClass)) {
                        DataMapConverter.this.recordConflict(path, "Unknown type for Cayenne query '" + jpaQuery.getName() + "': " + cayenneQueryClass.getName());
                        return null;
                    }
                    cayenneQuery = (JpaIndirectQuery)cayenneQueryClass.newInstance();
                }
                catch (Exception e) {
                    DataMapConverter.this.recordConflict(path, "Problem while creating Cayenne query '" + jpaQuery.getName() + "', exception" + e.getMessage());
                    return null;
                }
            } else {
                cayenneQuery = new JpaEjbQLQuery();
            }
            cayenneQuery.setName(jpaQuery.getName());
            cayenneQuery.setJpaQuery(jpaQuery);
            DataMap parentMap = DataMapConverter.this.targetPath.firstInstanceOf(DataMap.class);
            ObjEntity parentEntity = DataMapConverter.this.targetPath.firstInstanceOf(ObjEntity.class);
            if (parentEntity != null) {
                cayenneQuery.setParentEntity(parentEntity);
            } else {
                cayenneQuery.setParentMap(parentMap);
            }
            parentMap.addQuery(cayenneQuery);
            return cayenneQuery;
        }
    }

    abstract class JpaRelationshipVisitor
    extends NestedVisitor {
        JpaRelationshipVisitor() {
            this.addChildVisitor(JpaJoinColumn.class, new JpaJoinColumnVisitor());
        }

        Object createObject(ProjectPath path) {
            JpaRelationship relationship = (JpaRelationship)path.getObject();
            ObjEntity cayenneSrcEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            ObjRelationship cayenneRelationship = new ObjRelationship(relationship.getName());
            cayenneSrcEntity.addRelationship(cayenneRelationship);
            JpaEntity jpaTargetEntity = ((JpaEntityMap)path.getRoot()).entityForClass(relationship.getTargetEntityName());
            if (jpaTargetEntity == null) {
                DataMapConverter.this.recordConflict(path, "Unknown target entity '" + relationship.getTargetEntityName());
                return null;
            }
            cayenneRelationship.setTargetEntityName(jpaTargetEntity.getName());
            DbEntity cayenneSrcDbEntity = cayenneSrcEntity.getDbEntity();
            DbEntity cayenneTargetDbEntity = cayenneSrcEntity.getDataMap().getDbEntity(jpaTargetEntity.getTable().getName());
            if (cayenneTargetDbEntity == null) {
                cayenneTargetDbEntity = new DbEntity(jpaTargetEntity.getTable().getName());
                cayenneSrcEntity.getDataMap().addDbEntity(cayenneTargetDbEntity);
            }
            JpaDbRelationship dbRelationship = new JpaDbRelationship(cayenneRelationship.getName());
            dbRelationship.setTargetEntity(cayenneTargetDbEntity);
            dbRelationship.setToMany(relationship.isToMany());
            cayenneSrcDbEntity.addRelationship(dbRelationship);
            cayenneRelationship.addDbRelationship(dbRelationship);
            return cayenneRelationship;
        }
    }

    class JpaManyToManyVisitor
    extends JpaRelationshipVisitor {
        JpaManyToManyVisitor() {
        }

        Object createObject(ProjectPath path) {
            ObjRelationship objRelationship = (ObjRelationship)super.createObject(path);
            JpaDbRelationship relationship = (JpaDbRelationship)objRelationship.getDbRelationships().get(0);
            if (relationship != null) {
                JpaManyToMany jpaRelationship = (JpaManyToMany)path.getObject();
                relationship.setMappedBy(jpaRelationship.getMappedBy());
            }
            return relationship;
        }
    }

    class JpaOneToOneVisitor
    extends JpaRelationshipVisitor {
        JpaOneToOneVisitor() {
        }

        Object createObject(ProjectPath path) {
            ObjRelationship objRelationship = (ObjRelationship)super.createObject(path);
            JpaDbRelationship relationship = (JpaDbRelationship)objRelationship.getDbRelationships().get(0);
            if (relationship != null) {
                JpaOneToOne jpaRelationship = (JpaOneToOne)path.getObject();
                relationship.setMappedBy(jpaRelationship.getMappedBy());
            }
            return relationship;
        }
    }

    class JpaOneToManyVisitor
    extends JpaRelationshipVisitor {
        JpaOneToManyVisitor() {
        }

        Object createObject(ProjectPath path) {
            ObjRelationship objRelationship = (ObjRelationship)super.createObject(path);
            JpaDbRelationship relationship = (JpaDbRelationship)objRelationship.getDbRelationships().get(0);
            if (relationship != null) {
                JpaOneToMany jpaRelationship = (JpaOneToMany)path.getObject();
                relationship.setMappedBy(jpaRelationship.getMappedBy());
                objRelationship.setMapKey(jpaRelationship.getMapKey());
                objRelationship.setCollectionType(jpaRelationship.getPropertyDescriptor().getType().getName());
            }
            return relationship;
        }
    }

    class JpaManyToOneVisitor
    extends JpaRelationshipVisitor {
        JpaManyToOneVisitor() {
        }

        Object createObject(ProjectPath path) {
            ObjRelationship objRelationship = (ObjRelationship)super.createObject(path);
            return objRelationship.getDbRelationships().get(0);
        }
    }

    class JpaEntityVisitor
    extends NestedVisitor {
        JpaEntityVisitor() {
            BaseTreeVisitor listenersVisitor = new BaseTreeVisitor();
            listenersVisitor.addChildVisitor(JpaEntityListener.class, new JpaEntityListenerVisitor());
            BaseTreeVisitor attributeVisitor = new BaseTreeVisitor();
            attributeVisitor.addChildVisitor(JpaManyToOne.class, new JpaManyToOneVisitor());
            attributeVisitor.addChildVisitor(JpaOneToOne.class, new JpaOneToOneVisitor());
            attributeVisitor.addChildVisitor(JpaOneToMany.class, new JpaOneToManyVisitor());
            attributeVisitor.addChildVisitor(JpaManyToMany.class, new JpaManyToManyVisitor());
            JpaBasicVisitor basicVisitor = new JpaBasicVisitor();
            basicVisitor.addChildVisitor(JpaColumn.class, new JpaColumnVisitor());
            attributeVisitor.addChildVisitor(JpaBasic.class, basicVisitor);
            JpaEmbeddedVisitor embeddedVisitor = new JpaEmbeddedVisitor();
            attributeVisitor.addChildVisitor(JpaEmbedded.class, embeddedVisitor);
            JpaVersionVisitor versionVisitor = new JpaVersionVisitor();
            versionVisitor.addChildVisitor(JpaColumn.class, new JpaColumnVisitor());
            attributeVisitor.addChildVisitor(JpaVersion.class, versionVisitor);
            JpaIdVisitor idVisitor = new JpaIdVisitor();
            idVisitor.addChildVisitor(JpaColumn.class, new JpaIdColumnVisitor());
            attributeVisitor.addChildVisitor(JpaId.class, idVisitor);
            this.addChildVisitor(JpaAttributes.class, attributeVisitor);
            this.addChildVisitor(JpaTable.class, new JpaTableVisitor());
            this.addChildVisitor(JpaSecondaryTable.class, new JpaSecondaryTableVisitor());
            this.addChildVisitor(JpaNamedQuery.class, new JpaNamedQueryVisitor());
            this.addChildVisitor(JpaEntityListeners.class, listenersVisitor);
        }

        Object createObject(ProjectPath path) {
            JpaEntity jpaEntity = (JpaEntity)path.getObject();
            ObjEntity cayenneEntity = new ObjEntity(jpaEntity.getName());
            if (jpaEntity.getInheritance() == null && jpaEntity.lookupInheritanceStrategy() == InheritanceType.SINGLE_TABLE) {
                cayenneEntity.setSuperEntityName(jpaEntity.getSuperEntity().getName());
            }
            cayenneEntity.setClassName(jpaEntity.getClassName());
            this.initCallbacks(jpaEntity, cayenneEntity);
            ((DataMap)DataMapConverter.this.targetPath.getObject()).addObjEntity(cayenneEntity);
            return cayenneEntity;
        }

        private void initCallbacks(JpaEntity jpaEntity, ObjEntity cayenneEntity) {
            if (jpaEntity.getPostLoad() != null) {
                cayenneEntity.getCallbackMap().getPostLoad().addCallbackMethod(jpaEntity.getPostLoad().getMethodName());
            }
            if (jpaEntity.getPostPersist() != null) {
                cayenneEntity.getCallbackMap().getPostPersist().addCallbackMethod(jpaEntity.getPostPersist().getMethodName());
            }
            if (jpaEntity.getPostRemove() != null) {
                cayenneEntity.getCallbackMap().getPostRemove().addCallbackMethod(jpaEntity.getPostRemove().getMethodName());
            }
            if (jpaEntity.getPostUpdate() != null) {
                cayenneEntity.getCallbackMap().getPostUpdate().addCallbackMethod(jpaEntity.getPostUpdate().getMethodName());
            }
            if (jpaEntity.getPrePersist() != null) {
                cayenneEntity.getCallbackMap().getPrePersist().addCallbackMethod(jpaEntity.getPrePersist().getMethodName());
            }
            if (jpaEntity.getPreRemove() != null) {
                cayenneEntity.getCallbackMap().getPreRemove().addCallbackMethod(jpaEntity.getPreRemove().getMethodName());
            }
            if (jpaEntity.getPreUpdate() != null) {
                cayenneEntity.getCallbackMap().getPreUpdate().addCallbackMethod(jpaEntity.getPreUpdate().getMethodName());
            }
        }

        public void onFinishNode(ProjectPath path) {
            JpaEntity entity = path.firstInstanceOf(JpaEntity.class);
            DataMap dataMap = DataMapConverter.this.targetPath.firstInstanceOf(DataMap.class);
            ObjEntity cayenneEntity = DataMapConverter.this.targetPath.firstInstanceOf(ObjEntity.class);
            DbEntity cayennePrimaryTable = dataMap.getDbEntity(entity.lookupTable().getName());
            for (JpaSecondaryTable secondaryTable : entity.getSecondaryTables()) {
                DbEntity cayenneSecondaryTable = dataMap.getDbEntity(secondaryTable.getName());
                JpaDbRelationship dbRelationship = new JpaDbRelationship(DataMapConverter.this.getSecondaryTableDbRelationshipName(secondaryTable.getName()));
                dbRelationship.setTargetEntityName(secondaryTable.getName());
                cayennePrimaryTable.addRelationship(dbRelationship);
                for (JpaPrimaryKeyJoinColumn column : secondaryTable.getPrimaryKeyJoinColumns()) {
                    DbAttribute pkAttribute = (DbAttribute)cayennePrimaryTable.getAttribute(column.getReferencedColumnName());
                    if (pkAttribute == null) {
                        DataMapConverter.this.recordConflict(path, "Invalid referenced column name: " + column.getReferencedColumnName());
                        continue;
                    }
                    DbAttribute attribute = new DbAttribute(column.getName());
                    attribute.setPrimaryKey(true);
                    attribute.setMandatory(true);
                    attribute.setAttributePrecision(pkAttribute.getAttributePrecision());
                    attribute.setType(pkAttribute.getType());
                    attribute.setMaxLength(pkAttribute.getMaxLength());
                    attribute.setAttributePrecision(pkAttribute.getAttributePrecision());
                    cayenneSecondaryTable.addAttribute(attribute);
                    DbJoin join = new DbJoin(dbRelationship, column.getReferencedColumnName(), column.getName());
                    dbRelationship.addJoin(join);
                }
                dbRelationship.setToDependentPK(true);
                dbRelationship.setToMany(false);
            }
            JpaDiscriminatorColumn discriminator = entity.lookupDiscriminatorColumn();
            if (discriminator != null) {
                String valueString;
                if (cayennePrimaryTable.getAttribute(discriminator.getName()) == null) {
                    DbAttribute dbAttribute = new DbAttribute(discriminator.getName());
                    switch (discriminator.getDiscriminatorType()) {
                        case CHAR: {
                            dbAttribute.setType(1);
                            dbAttribute.setMaxLength(1);
                            break;
                        }
                        case STRING: {
                            dbAttribute.setType(12);
                            dbAttribute.setMaxLength(discriminator.getLength());
                            break;
                        }
                        case INTEGER: {
                            dbAttribute.setType(4);
                        }
                    }
                    dbAttribute.setMandatory(false);
                    cayennePrimaryTable.addAttribute(dbAttribute);
                }
                if ((valueString = entity.getDiscriminatorValue()) != null && valueString.length() > 0) {
                    Object value = null;
                    switch (discriminator.getDiscriminatorType()) {
                        case CHAR: {
                            value = Character.valueOf(valueString.charAt(0));
                            break;
                        }
                        case STRING: {
                            value = valueString;
                            break;
                        }
                        case INTEGER: {
                            try {
                                value = Integer.valueOf(valueString);
                                break;
                            }
                            catch (NumberFormatException e) {
                                DataMapConverter.this.recordConflict(path, "Invalid integer discriminator value '" + valueString);
                            }
                        }
                    }
                    if (value != null) {
                        cayenneEntity.setDeclaredQualifier(ExpressionFactory.matchDbExp(discriminator.getName(), value));
                    }
                }
            }
            super.onFinishNode(path);
        }
    }

    class JpaEmbeddableVisitor
    extends NestedVisitor {
        JpaEmbeddableVisitor() {
            BaseTreeVisitor attributeVisitor = new BaseTreeVisitor();
            JpaEmbeddableBasicVisitor basicVisitor = new JpaEmbeddableBasicVisitor();
            attributeVisitor.addChildVisitor(JpaBasic.class, basicVisitor);
            this.addChildVisitor(JpaAttributes.class, attributeVisitor);
        }

        Object createObject(ProjectPath path) {
            JpaEmbeddable jpaEmbeddable = (JpaEmbeddable)path.getObject();
            Embeddable embeddable = new Embeddable(jpaEmbeddable.getClassName());
            ((DataMap)DataMapConverter.this.targetPath.getObject()).addEmbeddable(embeddable);
            return embeddable;
        }
    }

    class JpaJoinColumnVisitor
    extends BaseTreeVisitor {
        JpaJoinColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaJoinColumn jpaJoin = (JpaJoinColumn)path.getObject();
            JpaRelationship jpaRelationship = (JpaRelationship)path.getObjectParent();
            JpaEntity targetEntity = DataMapConverter.this.context.getEntityMap().entityForClass(jpaRelationship.getTargetEntityName());
            JpaId jpaTargetId = targetEntity.getAttributes().getIdForColumnName(jpaJoin.getReferencedColumnName());
            if (jpaTargetId == null) {
                throw new IllegalArgumentException("Null id " + targetEntity.getName() + "." + jpaJoin.getReferencedColumnName());
            }
            DbRelationship dbRelationship = (DbRelationship)DataMapConverter.this.targetPath.getObject();
            DbAttribute src = new DbAttribute(jpaJoin.getName());
            src.setMandatory(false);
            src.setMaxLength(jpaTargetId.getColumn().getLength());
            src.setType(jpaTargetId.getDefaultJdbcType());
            Entity srcEntity = dbRelationship.getSourceEntity();
            srcEntity.addAttribute(src);
            DbJoin join = new DbJoin(dbRelationship, src.getName(), jpaTargetId.getColumn().getName());
            dbRelationship.addJoin(join);
            return false;
        }
    }

    class JpaIdColumnVisitor
    extends BaseTreeVisitor {
        JpaIdColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaColumn jpaColumn = (JpaColumn)path.getObject();
            DbAttribute dbAttribute = new DbAttribute(jpaColumn.getName());
            JpaId jpaId = path.firstInstanceOf(JpaId.class);
            dbAttribute.setType(jpaId.getDefaultJdbcType());
            dbAttribute.setMaxLength(jpaColumn.getLength());
            dbAttribute.setMandatory(true);
            dbAttribute.setPrimaryKey(true);
            if (jpaColumn.getScale() > 0) {
                dbAttribute.setScale(jpaColumn.getScale());
            }
            if (jpaColumn.getPrecision() > 0) {
                dbAttribute.setAttributePrecision(jpaColumn.getPrecision());
            }
            if (jpaColumn.getTable() == null) {
                DataMapConverter.this.recordConflict(path, "No table defined for JpaColumn '" + jpaColumn.getName() + "'");
                return false;
            }
            DbEntity entity = DataMapConverter.this.targetPath.firstInstanceOf(DataMap.class).getDbEntity(jpaColumn.getTable());
            if (entity == null) {
                DataMapConverter.this.recordConflict(path, "Invalid table definition for JpaColumn: " + jpaColumn.getTable() + "'");
                return false;
            }
            entity.addAttribute(dbAttribute);
            return false;
        }
    }

    class JpaIdVisitor
    extends JpaBasicVisitor {
        JpaIdVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaId id = (JpaId)path.getObject();
            ObjEntity parentCayenneEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            ObjAttribute cayenneAttribute = new ObjAttribute(id.getName());
            cayenneAttribute.setType(this.getAttributeType(path, id.getName()).getName());
            cayenneAttribute.setDbAttributePath(id.getColumn().getName());
            parentCayenneEntity.addAttribute(cayenneAttribute);
            return cayenneAttribute;
        }
    }

    class JpaColumnVisitor
    extends BaseTreeVisitor {
        JpaColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaColumn jpaColumn = (JpaColumn)path.getObject();
            if (jpaColumn.getTable() == null) {
                throw new JpaProviderException("No default table defined for JpaColumn " + jpaColumn.getName());
            }
            JpaAttribute attribute = (JpaAttribute)path.getObjectParent();
            DataMapConverter.this.createDbAttribute(jpaColumn.getTable(), jpaColumn, attribute);
            return false;
        }
    }

    class JpaVersionVisitor
    extends JpaBasicVisitor {
        JpaVersionVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaManagedClass entity = path.firstInstanceOf(JpaManagedClass.class);
            JpaVersion version = (JpaVersion)path.getObject();
            ObjEntity parentCayenneEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            ObjAttribute cayenneAttribute = new ObjAttribute(version.getName());
            cayenneAttribute.setType(this.getAttributeType(path, version.getName()).getName());
            cayenneAttribute.setDbAttributePath(this.getAttributePath(path, entity, version.getColumn()));
            parentCayenneEntity.addAttribute(cayenneAttribute);
            return cayenneAttribute;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JpaBasicVisitor
    extends NestedVisitor {
        JpaBasicVisitor() {
        }

        @Override
        Object createObject(ProjectPath path) {
            JpaManagedClass entity = path.firstInstanceOf(JpaManagedClass.class);
            JpaBasic jpaBasic = (JpaBasic)path.getObject();
            ObjEntity parentCayenneEntity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            ObjAttribute cayenneAttribute = new ObjAttribute(jpaBasic.getName());
            cayenneAttribute.setType(this.getAttributeType(path, jpaBasic.getName()).getName());
            cayenneAttribute.setDbAttributePath(this.getAttributePath(path, entity, jpaBasic.getColumn()));
            parentCayenneEntity.addAttribute(cayenneAttribute);
            return cayenneAttribute;
        }

        Class<?> getAttributeType(ProjectPath path, String name) {
            AccessType access = null;
            JpaManagedClass entity = path.firstInstanceOf(JpaManagedClass.class);
            access = entity.getAccess();
            if (access == null) {
                JpaEntityMap map = path.firstInstanceOf(JpaEntityMap.class);
                access = map.getAccess();
            }
            Class<?> objectClass = DataMapConverter.this.targetPath.firstInstanceOf(ObjEntity.class).getJavaClass();
            try {
                if (access == AccessType.FIELD) {
                    return DataMapConverter.this.lookupFieldInHierarchy(objectClass, name).getType();
                }
                return new PropertyDescriptor(name, objectClass).getPropertyType();
            }
            catch (Exception e) {
                throw new JpaProviderException("Error resolving attribute '" + name + "', access type:" + (Object)((Object)access) + ", class: " + objectClass.getName(), e);
            }
        }

        protected String getAttributePath(ProjectPath path, JpaManagedClass managedClass, JpaColumn column) {
            if (managedClass instanceof JpaEntity) {
                JpaEntity entity = (JpaEntity)managedClass;
                if (column.getTable().equals(entity.lookupTable().getName())) {
                    return column.getName();
                }
                JpaSecondaryTable table = entity.getSecondaryTable(column.getTable());
                if (table == null) {
                    DataMapConverter.this.recordConflict(path, "Unrecognized secondary table: '" + column.getTable() + "'");
                    return column.getName();
                }
                return DataMapConverter.this.getSecondaryTableDbRelationshipName(table.getName()) + '.' + column.getName();
            }
            return column.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JpaEmbeddableBasicVisitor
    extends NestedVisitor {
        JpaEmbeddableBasicVisitor() {
        }

        @Override
        Object createObject(ProjectPath path) {
            JpaBasic jpaBasic = (JpaBasic)path.getObject();
            Embeddable embeddable = (Embeddable)DataMapConverter.this.targetPath.getObject();
            EmbeddableAttribute attribute = new EmbeddableAttribute(jpaBasic.getName());
            attribute.setType(this.getAttributeType(path, jpaBasic.getName()).getName());
            attribute.setDbAttributeName(jpaBasic.getColumn().getName());
            embeddable.addAttribute(attribute);
            return attribute;
        }

        Class<?> getAttributeType(ProjectPath path, String name) {
            AccessType access = null;
            JpaManagedClass entity = path.firstInstanceOf(JpaManagedClass.class);
            access = entity.getAccess();
            if (access == null) {
                JpaEntityMap map = path.firstInstanceOf(JpaEntityMap.class);
                access = map.getAccess();
            }
            Class<?> objectClass = DataMapConverter.this.targetPath.firstInstanceOf(Embeddable.class).getJavaClass();
            try {
                if (access == AccessType.FIELD) {
                    return DataMapConverter.this.lookupFieldInHierarchy(objectClass, name).getType();
                }
                return new PropertyDescriptor(name, objectClass).getPropertyType();
            }
            catch (Exception e) {
                throw new JpaProviderException("Error resolving attribute '" + name + "', access type:" + (Object)((Object)access) + ", class: " + objectClass.getName(), e);
            }
        }
    }

    class JpaEmbeddedVisitor
    extends NestedVisitor {
        JpaEmbeddedVisitor() {
        }

        Object createObject(ProjectPath path) {
            JpaEmbedded jpaEmbedded = (JpaEmbedded)path.getObject();
            ObjEntity entity = (ObjEntity)DataMapConverter.this.targetPath.getObject();
            EmbeddedAttribute embedded = new EmbeddedAttribute(jpaEmbedded.getName());
            embedded.setType(jpaEmbedded.getPropertyDescriptor().getType().getName());
            for (JpaAttributeOverride override : jpaEmbedded.getAttributeOverrides()) {
                embedded.addAttributeOverride(override.getName(), override.getColumn().getName());
            }
            entity.addAttribute(embedded);
            JpaEmbeddable jpaEmbeddable = path.firstInstanceOf(JpaEntityMap.class).embeddableForClass(jpaEmbedded.getPropertyDescriptor().getType());
            for (JpaBasic jpaBasic : jpaEmbeddable.getAttributes().getBasicAttributes()) {
                JpaColumn column = jpaBasic.getColumn();
                String tableName = column.getTable() != null ? column.getTable() : entity.getDbEntityName();
                DataMapConverter.this.createDbAttribute(tableName, jpaBasic.getColumn(), jpaBasic);
            }
            return embedded;
        }
    }

    class JpaEntityListenerVisitor
    extends BaseTreeVisitor {
        JpaEntityListenerVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntityListener jpaListener = (JpaEntityListener)path.getObject();
            EntityListener listener = DataMapConverter.this.makeEntityListener(jpaListener);
            ObjEntity entity = DataMapConverter.this.targetPath.firstInstanceOf(ObjEntity.class);
            entity.addEntityListener(listener);
            return false;
        }
    }

    class JpaDefaultEntityListenerVisitor
    extends BaseTreeVisitor {
        JpaDefaultEntityListenerVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntityListener jpaListener = (JpaEntityListener)path.getObject();
            DataMap map = DataMapConverter.this.targetPath.firstInstanceOf(DataMap.class);
            EntityListener listener = DataMapConverter.this.makeEntityListener(jpaListener);
            map.addDefaultEntityListener(listener);
            return false;
        }
    }
}

