/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.trans.SelectTranslator;
import org.apache.cayenne.query.QueryMetadata;

public class OracleSelectTranslator
extends SelectTranslator {
    private static boolean testedDriver;
    private static boolean useOptimizations;
    private static Method statementSetRowPrefetch;
    private static final Object[] rowPrefetchArgs;

    public String createSqlString() throws Exception {
        String sqlString = super.createSqlString();
        QueryMetadata info = this.getQuery().getMetaData(this.getEntityResolver());
        if (info.getFetchLimit() > 0) {
            sqlString = "SELECT * FROM (" + sqlString + ") WHERE rownum <= " + info.getFetchLimit();
        }
        return sqlString;
    }

    private static final synchronized void testDriver(Statement st) {
        if (testedDriver) {
            return;
        }
        if (st == null) {
            return;
        }
        testedDriver = true;
        try {
            Class[] args2 = new Class[]{Integer.TYPE};
            statementSetRowPrefetch = st.getClass().getMethod("setRowPrefetch", args2);
            useOptimizations = true;
        }
        catch (Exception ex) {
            useOptimizations = false;
            statementSetRowPrefetch = null;
        }
    }

    public PreparedStatement createStatement() throws Exception {
        String sqlStr = this.createSqlString();
        QueryLogger.logQuery(sqlStr, this.values);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        if (!testedDriver) {
            OracleSelectTranslator.testDriver(stmt);
        }
        if (useOptimizations) {
            statementSetRowPrefetch.invoke((Object)stmt, rowPrefetchArgs);
        }
        return stmt;
    }

    static {
        rowPrefetchArgs = new Object[]{100};
    }
}

