/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;

public class OpenBaseQualifierTranslator
extends QualifierTranslator {
    public OpenBaseQualifierTranslator() {
        this(null);
    }

    public OpenBaseQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    public void startNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            this.detectObjectMatch(node);
            if (this.parenthesisNeeded(node, parentNode)) {
                this.qualBuf.append('(');
            }
        } else {
            super.startNode(node, parentNode);
        }
    }

    public void endNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            if (this.matchingObject) {
                this.appendObjectMatch();
            }
            if (this.parenthesisNeeded(node, parentNode)) {
                this.qualBuf.append(')');
            }
        } else {
            super.endNode(node, parentNode);
        }
    }

    protected void appendLiteralDirect(StringBuffer buf, Object val, DbAttribute attr, Expression parentExpression) {
        if (val instanceof String && (parentExpression.getType() == 11 || parentExpression.getType() == 37)) {
            val = this.caseSensitiveLikePattern((String)val);
        }
        super.appendLiteralDirect(buf, val, attr, parentExpression);
    }

    private String caseSensitiveLikePattern(String pattern) {
        int len = pattern.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '%' || c == '?') {
                buffer.append(c);
                continue;
            }
            buffer.append("[").append(c).append("]");
        }
        return buffer.toString();
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        switch (node.getType()) {
            case 12: {
                this.finishedChildNodeAppendExpression(node, " LIKE ");
                break;
            }
            case 38: {
                this.finishedChildNodeAppendExpression(node, " NOT LIKE ");
                break;
            }
            default: {
                super.finishedChild(node, childIndex, hasMoreChildren);
            }
        }
    }

    private void finishedChildNodeAppendExpression(Expression node, String operation) {
        StringBuffer buf = this.matchingObject ? new StringBuffer() : this.qualBuf;
        buf.append(operation);
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(buf.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }
}

