/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;
import org.apache.cayenne.dba.mysql.MySQLAdapter;

public class MySQLSniffer
implements DbAdapterFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("MYSQL")) {
            return null;
        }
        Statement statement = md.getConnection().createStatement();
        boolean supportFK = false;
        try {
            ResultSet rs = statement.executeQuery("SHOW VARIABLES LIKE 'table_type'");
            try {
                if (rs.next()) {
                    String tableType = rs.getString(2);
                    supportFK = tableType != null && tableType.toUpperCase().equals("INNODB");
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        MySQLAdapter adapter = new MySQLAdapter();
        adapter.setSupportsFkConstraints(supportFK);
        return adapter;
    }
}

