/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.mysql.MySQLActionBuilder;
import org.apache.cayenne.dba.mysql.MySQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.mysql.MySQLMergerFactory;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLAdapter
extends JdbcAdapter {
    public MySQLAdapter() {
        this.setSupportsFkConstraints(false);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    public String dropTable(DbEntity table) {
        return "DROP TABLE IF EXISTS " + table.getFullyQualifiedName() + " CASCADE";
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Arrays.asList("SET FOREIGN_KEY_CHECKS=0", "DROP TABLE IF EXISTS " + table.getFullyQualifiedName() + " CASCADE", "SET FOREIGN_KEY_CHECKS=1");
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(false, false));
        map.registerType(new ByteArrayType(false, false));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (typeName != null) {
            typeName = typeName.toLowerCase();
        }
        if (type == 1111) {
            if ("longblob".equals(typeName)) {
                type = 2004;
            } else if ("mediumblob".equals(typeName)) {
                type = 2004;
            } else if ("blob".equals(typeName)) {
                type = 2004;
            } else if ("tinyblob".equals(typeName)) {
                type = -3;
            } else if ("longtext".equals(typeName)) {
                type = 2005;
            } else if ("mediumtext".equals(typeName)) {
                type = 2005;
            } else if ("text".equals(typeName)) {
                type = 2005;
            } else if ("tinytext".equals(typeName)) {
                type = 12;
            }
        } else if (typeName != null && typeName.endsWith(" unsigned") && (typeName.equals("int unsigned") || typeName.equals("integer unsigned") || typeName.equals("mediumint unsigned"))) {
            type = -5;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    public String tableTypeForView() {
        return null;
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator();
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new MySQLEJBQLTranslatorFactory();
    }

    @Override
    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        ddlSQL = ddlSQL + " ENGINE=InnoDB";
        return ddlSQL;
    }

    @Override
    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        ArrayList<DbAttribute> pkList = new ArrayList<DbAttribute>(entity.getPrimaryKeys());
        Collections.sort(pkList, new PKComparator());
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(at.getName());
            }
            sqlBuffer.append(')');
        }
        if (this.supportsFkConstraints()) {
            for (DbRelationship r : entity.getRelationships()) {
                DbRelationship relationship = r;
                if (relationship.getJoins().size() <= 0 || !relationship.isToPK() || relationship.isToDependentPK()) continue;
                sqlBuffer.append(", KEY (");
                Iterator<DbAttribute> columns = relationship.getSourceAttributes().iterator();
                DbAttribute column = columns.next();
                sqlBuffer.append(column.getName());
                while (columns.hasNext()) {
                    column = columns.next();
                    sqlBuffer.append(", ").append(column.getName());
                }
                sqlBuffer.append(")");
            }
        }
    }

    @Override
    protected void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    @Override
    public MergerFactory mergerFactory() {
        return new MySQLMergerFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PKComparator
    implements Comparator<DbAttribute> {
        PKComparator() {
        }

        @Override
        public int compare(DbAttribute a1, DbAttribute a2) {
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

