/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.ingres;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.ingres.IngresCharType;
import org.apache.cayenne.dba.ingres.IngresPkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class IngresAdapter
extends JdbcAdapter {
    public static final String TRIM_FUNCTION = "TRIM";

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    public String createTable(DbEntity ent) {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator<DbAttribute> it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int scale;
                int len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator<DbAttribute> pkit = ent.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new IngresCharType());
    }

    protected PkGenerator createPkGenerator() {
        return new IngresPkGenerator();
    }
}

