/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class DistinctResultIterator
implements ResultIterator {
    protected ResultIterator wrappedIterator;
    protected Set fetchedIds;
    protected Map nextDataRow;
    protected DbEntity defaultEntity;
    protected boolean compareFullRows;
    protected boolean readingIds;

    public DistinctResultIterator(ResultIterator wrappedIterator, DbEntity defaultEntity, boolean compareFullRows) throws CayenneException {
        if (wrappedIterator == null) {
            throw new CayenneException("Null wrapped iterator.");
        }
        if (defaultEntity == null) {
            throw new CayenneException("Null defaultEntity.");
        }
        this.wrappedIterator = wrappedIterator;
        this.defaultEntity = defaultEntity;
        this.fetchedIds = new HashSet();
        this.compareFullRows = compareFullRows;
        this.checkNextRow();
    }

    public void close() throws CayenneException {
        this.wrappedIterator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List dataRows(boolean close) throws CayenneException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (this.hasNextRow()) {
                list.add(this.nextDataRow());
            }
            ArrayList<Map> arrayList = list;
            return arrayList;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    public int getDataRowWidth() {
        return this.wrappedIterator.getDataRowWidth();
    }

    public boolean hasNextRow() throws CayenneException {
        return this.nextDataRow != null;
    }

    public Map nextDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Map row = this.nextDataRow;
        this.checkNextRow();
        return row;
    }

    public Map nextObjectId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Map row = this.nextDataRow;
        if (!this.readingIds) {
            Iterator it = row.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                DbAttribute attribute = (DbAttribute)entity.getAttribute(name);
                if (attribute != null && attribute.isPrimaryKey()) continue;
                it.remove();
            }
        }
        this.checkNextId(entity);
        return row;
    }

    public void skipDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        if (this.readingIds) {
            this.checkNextId(this.defaultEntity);
        } else {
            this.checkNextRow();
        }
    }

    void checkNextRow() throws CayenneException {
        if (this.readingIds) {
            throw new CayenneException("Can't go back from reading ObjectIds to reading rows.");
        }
        if (this.compareFullRows) {
            this.checkNextUniqueRow();
        } else {
            this.checkNextRowWithUniqueId();
        }
    }

    void checkNextUniqueRow() throws CayenneException {
        this.nextDataRow = null;
        while (this.wrappedIterator.hasNextRow()) {
            Map<String, Object> next = this.wrappedIterator.nextDataRow();
            if (!this.fetchedIds.add(next)) continue;
            this.nextDataRow = next;
            break;
        }
    }

    void checkNextRowWithUniqueId() throws CayenneException {
        this.nextDataRow = null;
        while (this.wrappedIterator.hasNextRow()) {
            Map<String, Object> next = this.wrappedIterator.nextDataRow();
            HashMap<String, Object> id = new HashMap<String, Object>();
            for (DbAttribute pk : this.defaultEntity.getPrimaryKeys()) {
                id.put(pk.getName(), next.get(pk.getName()));
            }
            if (!this.fetchedIds.add(id)) continue;
            this.nextDataRow = next;
            break;
        }
    }

    void checkNextId(DbEntity entity) throws CayenneException {
        if (entity == null) {
            throw new CayenneException("Null DbEntity, can't create id.");
        }
        this.readingIds = true;
        this.nextDataRow = null;
        while (this.wrappedIterator.hasNextRow()) {
            Map<String, Object> next = this.wrappedIterator.nextObjectId(entity);
            if (!this.fetchedIds.add(next)) continue;
            this.nextDataRow = next;
            break;
        }
    }
}

