/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.trans.OrderingTranslator;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTranslator
extends QueryAssembler {
    protected static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, -4, -1};
    final Map aliasLookup = new HashMap();
    final List<DbEntity> tableList = new ArrayList<DbEntity>();
    final List<String> aliasList = new ArrayList<String>();
    final List<DbRelationship> dbRelList = new ArrayList<DbRelationship>();
    List<ColumnDescriptor> resultColumns;
    Map attributeOverrides;
    Map defaultAttributesByColumn;
    int aliasCounter;
    boolean suppressingDistinct;
    boolean forcingDistinct;

    protected static boolean isUnsupportedForDistinct(int type) {
        for (int i = 0; i < UNSUPPORTED_DISTINCT_TYPES.length; ++i) {
            if (UNSUPPORTED_DISTINCT_TYPES[i] != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public String createSqlString() throws Exception {
        this.forcingDistinct = false;
        this.resultColumns = this.buildResultColumns();
        QualifierTranslator tr = this.adapter.getQualifierTranslator(this);
        String qualifierStr = tr.doTranslation();
        OrderingTranslator orderingTranslator = new OrderingTranslator(this);
        String orderByStr = orderingTranslator.doTranslation();
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            this.suppressingDistinct = false;
            for (ColumnDescriptor column : this.resultColumns) {
                if (!SelectTranslator.isUnsupportedForDistinct(column.getJdbcType())) continue;
                this.suppressingDistinct = true;
                break;
            }
            if (!this.suppressingDistinct) {
                queryBuf.append("DISTINCT ");
            }
        }
        ArrayList<String> selectColumnExpList = new ArrayList<String>();
        for (ColumnDescriptor column : this.resultColumns) {
            selectColumnExpList.add(column.getQualifiedColumnName());
        }
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            List<String> orderByColumnList = orderingTranslator.getOrderByColumnList();
            for (int i = 0; i < orderByColumnList.size(); ++i) {
                String orderByColumnExp = orderByColumnList.get(i);
                if (selectColumnExpList.contains(orderByColumnExp)) continue;
                selectColumnExpList.add(orderByColumnExp);
            }
        }
        int columnCount = selectColumnExpList.size();
        queryBuf.append((String)selectColumnExpList.get(0));
        for (int i = 1; i < columnCount; ++i) {
            queryBuf.append(", ");
            queryBuf.append((String)selectColumnExpList.get(i));
        }
        queryBuf.append(" FROM ");
        int tableCount = this.tableList.size();
        this.appendTable(queryBuf, 0);
        for (int i = 1; i < tableCount; ++i) {
            queryBuf.append(", ");
            this.appendTable(queryBuf, i);
        }
        boolean hasWhere = false;
        int dbRelCount = this.dbRelList.size();
        if (dbRelCount > 0) {
            hasWhere = true;
            queryBuf.append(" WHERE ");
            this.appendJoins(queryBuf, 0);
            for (int i = 1; i < dbRelCount; ++i) {
                queryBuf.append(" AND ");
                this.appendJoins(queryBuf, i);
            }
        }
        if (qualifierStr != null) {
            if (hasWhere) {
                queryBuf.append(" AND (");
                queryBuf.append(qualifierStr);
                queryBuf.append(")");
            } else {
                hasWhere = true;
                queryBuf.append(" WHERE ");
                queryBuf.append(qualifierStr);
            }
        }
        if (orderByStr != null) {
            queryBuf.append(" ORDER BY ").append(orderByStr);
        }
        return queryBuf.toString();
    }

    public ColumnDescriptor[] getResultColumns() {
        if (this.resultColumns == null || this.resultColumns.isEmpty()) {
            return new ColumnDescriptor[0];
        }
        return this.resultColumns.toArray(new ColumnDescriptor[this.resultColumns.size()]);
    }

    public Map getAttributeOverrides() {
        return this.attributeOverrides != null ? this.attributeOverrides : Collections.EMPTY_MAP;
    }

    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    private SelectQuery getSelectQuery() {
        return (SelectQuery)this.getQuery();
    }

    List<ColumnDescriptor> buildResultColumns() {
        this.defaultAttributesByColumn = new HashMap();
        this.newAliasForTable(this.getRootDbEntity());
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        SelectQuery query = this.getSelectQuery();
        if (query.isFetchingCustomAttributes()) {
            this.appendCustomColumns(columns, query);
        } else {
            this.appendQueryColumns(columns, query);
        }
        return columns;
    }

    List<ColumnDescriptor> appendQueryColumns(final List<ColumnDescriptor> columns, SelectQuery query) {
        final HashSet attributes = new HashSet();
        ClassDescriptor descriptor = query.getMetaData(this.getEntityResolver()).getClassDescriptor();
        ObjEntity oe = descriptor.getEntity();
        PropertyVisitor visitor = new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                    }
                    if (pathPart instanceof DbRelationship) {
                        DbRelationship rel = (DbRelationship)pathPart;
                        SelectTranslator.this.dbRelationshipAdded(rel);
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    DbAttribute dbAttr = (DbAttribute)pathPart;
                    SelectTranslator.this.appendColumn(columns, oa, dbAttr, attributes, null);
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                List<DbJoin> joins = dbRel.getJoins();
                int len = joins.size();
                for (int i = 0; i < len; ++i) {
                    DbJoin join = joins.get(i);
                    DbAttribute src = join.getSource();
                    SelectTranslator.this.appendColumn(columns, null, src, attributes, null);
                }
            }
        };
        if (query.isResolvingInherited()) {
            descriptor.visitAllProperties(visitor);
        } else {
            descriptor.visitProperties(visitor);
        }
        DbEntity table = this.getRootDbEntity();
        for (DbAttribute dba : table.getPrimaryKeys()) {
            this.appendColumn(columns, null, dba, attributes, null);
        }
        if (query instanceof PrefetchSelectQuery) {
            for (String path : ((PrefetchSelectQuery)query).getResultPaths()) {
                Expression pathExp = oe.translateToDbPath(Expression.fromString(path));
                Iterator<CayenneMapEntry> it = table.resolvePathComponents(pathExp);
                CayenneMapEntry pathComponent = null;
                while (it.hasNext()) {
                    pathComponent = it.next();
                    if (!it.hasNext() || !(pathComponent instanceof DbRelationship)) continue;
                    this.dbRelationshipAdded((DbRelationship)pathComponent);
                }
                String labelPrefix = pathExp.toString().substring("db:".length());
                if (pathComponent instanceof DbAttribute) {
                    this.appendColumn(columns, null, (DbAttribute)pathComponent, attributes, labelPrefix);
                    continue;
                }
                if (!(pathComponent instanceof DbRelationship)) continue;
                DbRelationship relationship = (DbRelationship)pathComponent;
                if (relationship.isToMany()) {
                    this.dbRelationshipAdded(relationship);
                }
                for (DbJoin j : relationship.getJoins()) {
                    DbAttribute attribute = relationship.isToMany() ? j.getTarget() : j.getSource();
                    this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + j.getTargetName());
                }
            }
        }
        if (query.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().adjacentJointNodes()) {
                Expression prefetchExp = Expression.fromString(prefetch.getPath());
                Expression dbPrefetch = oe.translateToDbPath(prefetchExp);
                Iterator<CayenneMapEntry> it = table.resolvePathComponents(dbPrefetch);
                DbRelationship r = null;
                while (it.hasNext()) {
                    r = (DbRelationship)it.next();
                    this.dbRelationshipAdded(r);
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '" + prefetch + "' for entity: " + oe.getName());
                }
                ArrayList<DbAttribute> skipColumns = Collections.EMPTY_LIST;
                if (r.getSourceEntity() == table) {
                    skipColumns = new ArrayList<DbAttribute>(2);
                    for (DbJoin join : r.getJoins()) {
                        if (!attributes.contains(join.getSource())) continue;
                        skipColumns.add(join.getTarget());
                    }
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                Iterator<? extends Attribute> targetObjAttrs = targetRel.getTargetEntity().getAttributes().iterator();
                String labelPrefix = dbPrefetch.toString().substring("db:".length());
                while (targetObjAttrs.hasNext()) {
                    ObjAttribute oa = (ObjAttribute)targetObjAttrs.next();
                    Iterator<CayenneMapEntry> iterator = oa.getDbPathIterator();
                    while (iterator.hasNext()) {
                        DbAttribute attribute;
                        CayenneMapEntry pathPart = iterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                        }
                        if (pathPart instanceof DbRelationship) {
                            DbRelationship rel = (DbRelationship)pathPart;
                            this.dbRelationshipAdded(rel);
                            continue;
                        }
                        if (!(pathPart instanceof DbAttribute) || skipColumns.contains(attribute = (DbAttribute)pathPart)) continue;
                        this.appendColumn(columns, oa, attribute, attributes, labelPrefix + '.' + attribute.getName());
                    }
                }
                for (DbAttribute dbAttribute : r.getTargetEntity().getAttributes()) {
                    if (skipColumns.contains(dbAttribute)) continue;
                    this.appendColumn(columns, null, dbAttribute, attributes, labelPrefix + '.' + dbAttribute.getName());
                }
            }
        }
        return columns;
    }

    List<ColumnDescriptor> appendCustomColumns(List<ColumnDescriptor> columns, SelectQuery query) {
        List<String> customAttributes = query.getCustomDbAttributes();
        DbEntity table = this.getRootDbEntity();
        int len = customAttributes.size();
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = (DbAttribute)table.getAttribute(customAttributes.get(i));
            if (attribute == null) {
                throw new CayenneRuntimeException("Attribute does not exist: " + customAttributes.get(i));
            }
            String alias = this.aliasForTable((DbEntity)attribute.getEntity());
            columns.add(new ColumnDescriptor(attribute, alias));
        }
        return columns;
    }

    private void appendColumn(List<ColumnDescriptor> columns, ObjAttribute objAttribute, DbAttribute attribute, Set skipSet, String label) {
        if (skipSet.add(attribute)) {
            ColumnDescriptor column;
            String alias = this.aliasForTable((DbEntity)attribute.getEntity());
            ColumnDescriptor columnDescriptor = column = objAttribute != null ? new ColumnDescriptor(objAttribute, attribute, alias) : new ColumnDescriptor(attribute, alias);
            if (label != null) {
                column.setLabel(label);
            }
            columns.add(column);
            this.defaultAttributesByColumn.put(column, objAttribute);
        } else if (objAttribute != null) {
            for (ColumnDescriptor column : columns) {
                if (!attribute.getName().equals(column.getName())) continue;
                ObjAttribute original = (ObjAttribute)this.defaultAttributesByColumn.remove(column);
                if (original == null) break;
                if (this.attributeOverrides == null) {
                    this.attributeOverrides = new HashMap();
                }
                this.attributeOverrides.put(original, column);
                column.setJavaClass(Void.TYPE.getName());
                break;
            }
        }
    }

    private void appendTable(StringBuilder queryBuf, int index) {
        DbEntity ent = this.tableList.get(index);
        queryBuf.append(ent.getFullyQualifiedName());
        queryBuf.append(' ').append(this.aliasList.get(index));
    }

    private void appendJoins(StringBuilder queryBuf, int index) {
        DbRelationship rel = this.dbRelList.get(index);
        String srcAlias = this.aliasForTable((DbEntity)rel.getSourceEntity());
        String targetAlias = (String)this.aliasLookup.get(rel);
        boolean andFlag = false;
        List<DbJoin> joins = rel.getJoins();
        int len = joins.size();
        for (int i = 0; i < len; ++i) {
            DbJoin join = joins.get(i);
            if (andFlag) {
                queryBuf.append(" AND ");
            } else {
                andFlag = true;
            }
            queryBuf.append(srcAlias).append('.').append(join.getSourceName()).append(" = ").append(targetAlias).append('.').append(join.getTargetName());
        }
    }

    @Override
    public void dbRelationshipAdded(DbRelationship rel) {
        String existAlias;
        if (rel.isToMany()) {
            this.forcingDistinct = true;
        }
        if ((existAlias = (String)this.aliasLookup.get(rel)) == null) {
            this.dbRelList.add(rel);
            String newAlias = this.newAliasForTable((DbEntity)rel.getTargetEntity());
            this.aliasLookup.put(rel, newAlias);
        }
    }

    protected String newAliasForTable(DbEntity ent) {
        String newAlias = "t" + this.aliasCounter++;
        this.tableList.add(ent);
        this.aliasList.add(newAlias);
        return newAlias;
    }

    @Override
    public String aliasForTable(DbEntity ent, DbRelationship rel) {
        return (String)this.aliasLookup.get(rel);
    }

    @Override
    public String aliasForTable(DbEntity ent) {
        int entIndex = this.tableList.indexOf(ent);
        if (entIndex >= 0) {
            return this.aliasList.get(entIndex);
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Alias not found, DbEntity: '").append(ent != null ? ent.getName() : "<null entity>").append("'\nExisting aliases:");
        int len = this.aliasList.size();
        for (int i = 0; i < len; ++i) {
            String dbeName = this.tableList.get(i) != null ? this.tableList.get(i).getName() : "<null entity>";
            msg.append("\n").append(this.aliasList.get(i)).append(" => ").append(dbeName);
        }
        throw new CayenneRuntimeException(msg.toString());
    }

    @Override
    public boolean supportsTableAliases() {
        return true;
    }
}

