/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.QueryTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

public abstract class QueryAssembler
extends QueryTranslator {
    protected List<Object> values = new ArrayList<Object>();
    protected List<DbAttribute> attributes = new ArrayList<DbAttribute>();

    public abstract void dbRelationshipAdded(DbRelationship var1);

    public abstract String createSqlString() throws Exception;

    public String aliasForTable(DbEntity ent, DbRelationship rel) {
        return this.aliasForTable(ent);
    }

    public abstract String aliasForTable(DbEntity var1);

    public boolean supportsTableAliases() {
        return false;
    }

    public void addToParamList(DbAttribute dbAttr, Object anObject) {
        this.attributes.add(dbAttr);
        this.values.add(anObject);
    }

    public PreparedStatement createStatement() throws Exception {
        long t1 = System.currentTimeMillis();
        String sqlStr = this.createSqlString();
        QueryLogger.logQuery(sqlStr, this.attributes, this.values, System.currentTimeMillis() - t1);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }

    protected void initStatement(PreparedStatement stmt) throws Exception {
        if (this.values != null && this.values.size() > 0) {
            int len = this.values.size();
            for (int i = 0; i < len; ++i) {
                Object val = this.values.get(i);
                DbAttribute attr = this.attributes.get(i);
                if (attr == null) {
                    stmt.setObject(i + 1, val);
                    continue;
                }
                this.adapter.bindParameter(stmt, val, i + 1, attr.getType(), attr.getScale());
            }
        }
    }
}

