/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;

public class RowDescriptor {
    protected ColumnDescriptor[] columns;
    protected ExtendedType[] converters;

    protected RowDescriptor() {
    }

    public RowDescriptor(ColumnDescriptor[] columns, ExtendedTypeMap types) {
        this.columns = columns;
        this.indexTypes(types);
    }

    public RowDescriptor(ResultSet resultSet, ExtendedTypeMap types) {
        this(resultSet, types, null);
    }

    public RowDescriptor(ResultSet resultSet, ExtendedTypeMap types, Map javaTypeOverrides) {
        this.initFromResultSet(resultSet);
        if (javaTypeOverrides != null) {
            this.overrideJavaTypes(javaTypeOverrides);
        }
        this.indexTypes(types);
    }

    public void forceUpperCaseColumnNames() {
        for (ColumnDescriptor column : this.columns) {
            column.setLabel(column.getLabel().toUpperCase());
        }
    }

    public void forceLowerCaseColumnNames() {
        for (ColumnDescriptor column : this.columns) {
            column.setLabel(column.getLabel().toLowerCase());
        }
    }

    protected void indexTypes(ExtendedTypeMap types) {
        this.converters = new ExtendedType[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.converters[i] = types.getRegisteredType(this.columns[i].getJavaClass());
        }
    }

    protected void initFromResultSet(ResultSet resultSet) {
        try {
            ResultSetMetaData md = resultSet.getMetaData();
            int len = md.getColumnCount();
            if (len == 0) {
                throw new CayenneRuntimeException("No columns in ResultSet.");
            }
            this.columns = new ColumnDescriptor[len];
            for (int i = 0; i < len; ++i) {
                this.columns[i] = new ColumnDescriptor(md, i + 1);
            }
        }
        catch (SQLException sqex) {
            throw new CayenneRuntimeException("Error reading metadata.", sqex);
        }
    }

    protected void overrideJavaTypes(Map overrides) {
        for (ColumnDescriptor column : this.columns) {
            String type = (String)overrides.get(column.getName());
            if (type == null) continue;
            column.setJavaClass(type);
        }
    }

    public int getWidth() {
        return this.columns.length;
    }

    public ColumnDescriptor[] getColumns() {
        return this.columns;
    }

    public ExtendedType[] getConverters() {
        return this.converters;
    }
}

