/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.jdbc.EJBQLSelectTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

public class EJBQLJoinAppender {
    protected EJBQLTranslationContext context;
    private Map<String, String> reusableJoins;

    static String makeJoinTailMarker(String id) {
        return "FROM_TAIL" + id;
    }

    public EJBQLJoinAppender(EJBQLTranslationContext context) {
        this.context = context;
    }

    public String registerReusableJoin(String sourceIdPath, String relationship, String targetId) {
        String key;
        String oldId;
        if (this.reusableJoins == null) {
            this.reusableJoins = new HashMap<String, String>();
        }
        if ((oldId = this.reusableJoins.put(key = sourceIdPath + ":" + relationship, targetId)) != null) {
            this.reusableJoins.put(key, oldId);
            return oldId;
        }
        return null;
    }

    public void appendInnerJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "INNER JOIN");
    }

    public void appendOuterJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "LEFT OUTER JOIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId, String semantics) {
        List<DbRelationship> joinRelationships = this.context.getIncomingRelationships(rhsId);
        if (joinRelationships.isEmpty()) {
            throw new EJBQLException("No join configured for id " + rhsId);
        }
        DbRelationship incomingDB = joinRelationships.get(0);
        String sourceAlias = this.context.getTableAlias(lhsId.getEntityId(), incomingDB.getSourceEntity().getName());
        if (marker != null) {
            this.context.pushMarker(marker, false);
        }
        try {
            DbJoin dbJoin;
            this.context.append(" ").append(semantics);
            String targetAlias = this.appendTable(rhsId);
            this.context.append(" ON (");
            Iterator<DbJoin> it = incomingDB.getJoins().iterator();
            if (it.hasNext()) {
                dbJoin = it.next();
                this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
            }
            while (it.hasNext()) {
                this.context.append(", ");
                dbJoin = it.next();
                this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
            }
            this.context.append(")");
        }
        finally {
            if (marker != null) {
                this.context.popMarker();
            }
        }
    }

    public String appendTable(EJBQLTableId id) {
        Expression qualifier;
        String alias;
        String tableName = id.getDbEntity(this.context).getFullyQualifiedName();
        if (this.context.isUsingAliases()) {
            alias = this.context.getTableAlias(id.getEntityId(), tableName);
            this.context.append(' ').append(tableName).append(' ').append(alias);
        } else {
            this.context.append(' ').append(tableName);
            alias = tableName;
        }
        if (id.isPrimaryTable() && (qualifier = this.context.getEntityDescriptor(id.getEntityId()).getEntityQualifier()) != null) {
            EJBQLExpression ejbqlQualifier = this.ejbqlQualifierForEntityAndSubclasses(qualifier, id.getEntityId());
            this.context.pushMarker(EJBQLSelectTranslator.makeWhereMarker(), true);
            this.context.append(" WHERE");
            this.context.popMarker();
            this.context.pushMarker(EJBQLSelectTranslator.makeEntityQualifierMarker(), false);
            ejbqlQualifier.visit(this.context.getTranslatorFactory().getConditionTranslator(this.context));
            this.context.popMarker();
        }
        return alias;
    }

    private EJBQLExpression ejbqlQualifierForEntityAndSubclasses(Expression qualifier, String entityId) {
        String ejbqlChunk = qualifier.toEJBQL(entityId);
        EJBQLExpression expression = EJBQLParserFactory.getParser().parse("DELETE FROM DUMMY WHERE " + ejbqlChunk);
        final EJBQLExpression[] result = new EJBQLExpression[1];
        expression.visit(new EJBQLBaseVisitor(){

            public boolean visitWhere(EJBQLExpression expression) {
                result[0] = expression.getChild(0);
                return false;
            }
        });
        return result[0];
    }
}

