/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.util.ObjectContextGraphAction;

class DataContextGraphAction
extends ObjectContextGraphAction {
    DataContextGraphAction(DataContext context) {
        super(context);
    }

    protected void handleSimplePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        if (this.markAsDirty(object)) {
            this.context.getGraphManager().nodePropertyChanged(object.getObjectId(), propertyName, oldValue, newValue);
        }
    }

    protected void handleArcPropertyChange(Persistent object, ArcProperty property, Object oldValue, Object newValue) {
        if (oldValue != newValue) {
            this.markAsDirty(object);
            if (oldValue instanceof Persistent) {
                this.context.getGraphManager().arcDeleted(object.getObjectId(), ((Persistent)oldValue).getObjectId(), property.getName());
            }
            if (newValue instanceof Persistent) {
                this.context.getGraphManager().arcCreated(object.getObjectId(), ((Persistent)newValue).getObjectId(), property.getName());
            }
        }
    }
}

