/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.xml.SerializableEntity;
import org.apache.cayenne.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

final class XMLMappingDescriptor {
    private SerializableEntity rootEntity;
    private Map entities;
    private DataContext dataContext;

    XMLMappingDescriptor(String mappingUrl) throws CayenneRuntimeException {
        Document document;
        DocumentBuilder builder = XMLUtil.newBuilder();
        try {
            document = builder.parse(mappingUrl);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error parsing XML at " + mappingUrl, ex);
        }
        Element root = document.getDocumentElement();
        if (!"model".equals(root.getNodeName())) {
            throw new CayenneRuntimeException("Root of the mapping model must be \"model\"");
        }
        HashMap<String, SerializableEntity> entities = new HashMap<String, SerializableEntity>();
        Iterator it = XMLUtil.getChildren(root).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            SerializableEntity entity = new SerializableEntity(this, e);
            String tag = e.getAttribute("xmlTag");
            entities.put(tag, entity);
            if (this.rootEntity != null) continue;
            this.rootEntity = entity;
        }
        this.entities = entities;
    }

    SerializableEntity getRootEntity() {
        return this.rootEntity;
    }

    Object decode(Element xml, DataContext dataContext) throws CayenneRuntimeException {
        this.dataContext = dataContext;
        Object ret = this.createObject(this.rootEntity.getDescriptor(), xml);
        Iterator it = XMLUtil.getChildren(xml).iterator();
        while (it.hasNext()) {
            Element value = (Element)it.next();
            this.decodeProperty(ret, this.rootEntity.getDescriptor(), value);
        }
        return ret;
    }

    SerializableEntity getEntity(String name) {
        return (SerializableEntity)this.entities.get(name);
    }

    private String getPropertyMappingName(Element entityMapping, String propertyXmlTag) {
        Iterator it = XMLUtil.getChildren(entityMapping).iterator();
        while (it.hasNext()) {
            Element propertyMapping = (Element)it.next();
            if (!propertyXmlTag.equals(propertyMapping.getAttribute("xmlTag"))) continue;
            return propertyMapping.getAttribute("name");
        }
        return null;
    }

    private void decodeProperty(Object object, Element entityMapping, Element propertyData) throws CayenneRuntimeException {
        String xmlTag = propertyData.getNodeName();
        String propertyName = this.getPropertyMappingName(entityMapping, xmlTag);
        if (propertyName == null) {
            return;
        }
        SerializableEntity targetEntityMapping = this.getEntity(xmlTag);
        if (targetEntityMapping == null) {
            this.setProperty(object, propertyName, XMLUtil.getText(propertyData));
        } else {
            Object o = this.createObject(targetEntityMapping.getDescriptor(), propertyData);
            Iterator it = XMLUtil.getChildren(propertyData).iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                this.decodeProperty(o, targetEntityMapping.getDescriptor(), child);
            }
            this.setProperty(object, propertyName, o);
        }
    }

    private void setProperty(Object object, String propertyName, Object value) {
        try {
            PropertyUtils.setProperty(object, propertyName, value);
        }
        catch (CayenneRuntimeException e) {
            Object existingValue = PropertyUtils.getProperty(object, propertyName);
            if (existingValue instanceof Collection && !(value instanceof Collection)) {
                ((Collection)existingValue).add(value);
            }
            throw e;
        }
    }

    private Object createObject(Element entityMapping, Element objectData) {
        Object object;
        String className = entityMapping.getAttribute("name");
        try {
            object = Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating instance of class " + className, ex);
        }
        if (null != this.dataContext && object instanceof Persistent) {
            this.dataContext.registerNewObject(object);
        }
        NamedNodeMap attributes = objectData.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String propertyName = this.getPropertyMappingName(entityMapping, attribute.getName());
            if (propertyName == null) continue;
            PropertyUtils.setProperty(object, propertyName, attribute.getValue());
        }
        return object;
    }
}

