/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import foundrylogic.vpp.VPPConfig;
import java.io.File;
import org.apache.cayenne.gen.AntClassGenerator;
import org.apache.cayenne.gen.DefaultClassGenerator;
import org.apache.cayenne.tools.AntTaskLogger;
import org.apache.cayenne.tools.CayenneGeneratorUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class CayenneGenerator
extends Task {
    protected String includeEntitiesPattern;
    protected String excludeEntitiesPattern;
    protected VPPConfig vppConfig;
    protected File map;
    protected File[] additionalMaps;
    protected DefaultClassGenerator generator = this.createGenerator();
    protected CayenneGeneratorUtil generatorUtil = new CayenneGeneratorUtil();

    protected DefaultClassGenerator createGenerator() {
        AntClassGenerator gen = new AntClassGenerator();
        gen.setParentTask(this);
        return gen;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (!"1.1".equals(this.generator.getVersionString())) {
            this.initializeVppConfig();
            this.generator.setVppConfig(this.vppConfig);
        }
        this.generatorUtil.setAdditionalMaps(this.additionalMaps);
        this.generatorUtil.setExcludeEntitiesPattern(this.excludeEntitiesPattern);
        this.generatorUtil.setGenerator(this.generator);
        this.generatorUtil.setIncludeEntitiesPattern(this.includeEntitiesPattern);
        this.generatorUtil.setLogger(new AntTaskLogger(this));
        this.generatorUtil.setMap(this.map);
        try {
            this.generatorUtil.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.map == null && this.getProject() == null) {
            throw new BuildException("either 'map' or 'project' is required.");
        }
    }

    public void setMap(File map) {
        this.map = map;
    }

    public void setAdditionalMaps(Path additionalMapsPath) {
        String[] additionalMapFilenames = additionalMapsPath.list();
        this.additionalMaps = new File[additionalMapFilenames.length];
        for (int i = 0; i < additionalMapFilenames.length; ++i) {
            this.additionalMaps[i] = new File(additionalMapFilenames[i]);
        }
    }

    public void setDestDir(File destDir) {
        this.generator.setDestDir(destDir);
    }

    public void setOverwrite(boolean overwrite) {
        this.generator.setOverwrite(overwrite);
    }

    public void setMakepairs(boolean makepairs) {
        this.generator.setMakePairs(makepairs);
    }

    public void setTemplate(String template) {
        this.generator.setTemplate(template);
    }

    public void setSupertemplate(String supertemplate) {
        this.generator.setSuperTemplate(supertemplate);
    }

    public void setUsepkgpath(boolean usepkgpath) {
        this.generator.setUsePkgPath(usepkgpath);
    }

    public void setSuperpkg(String superpkg) {
        this.generator.setSuperPkg(superpkg);
    }

    public void setClient(boolean client) {
        this.generator.setClient(client);
    }

    public void setVersion(String versionString) {
        try {
            this.generator.setVersionString(versionString);
        }
        catch (IllegalStateException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setEncoding(String encoding) {
        this.generator.setEncoding(encoding);
    }

    public void setExcludeEntities(String excludeEntitiesPattern) {
        this.excludeEntitiesPattern = excludeEntitiesPattern;
    }

    public void setIncludeEntities(String includeEntitiesPattern) {
        this.includeEntitiesPattern = includeEntitiesPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.generator.setOutputPattern(outputPattern);
    }

    public void setMode(String mode) {
        this.generator.setMode(mode);
    }

    public Object createConfig() {
        this.vppConfig = new VPPConfig();
        return this.vppConfig;
    }

    private void initializeVppConfig() {
        if (this.vppConfig == null) {
            this.vppConfig = VPPConfig.getDefaultConfig((Project)this.getProject());
        }
    }
}

