/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Iterator;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

public class LazyClassDescriptorDecorator
implements ClassDescriptor {
    protected ClassDescriptor descriptor;
    protected ClassDescriptorMap descriptorMap;
    protected String entityName;

    public LazyClassDescriptorDecorator(ClassDescriptorMap descriptorMap, String entityName) {
        this.descriptorMap = descriptorMap;
        this.entityName = entityName;
    }

    protected void checkDescriptorInitialized() {
        if (this.descriptor == null) {
            this.descriptor = this.descriptorMap.createDescriptor(this.entityName);
        }
    }

    public ClassDescriptor getDescriptor() {
        this.checkDescriptorInitialized();
        return this.descriptor;
    }

    public Object createObject() {
        this.checkDescriptorInitialized();
        return this.descriptor.createObject();
    }

    public Property getDeclaredProperty(String propertyName) {
        this.checkDescriptorInitialized();
        return this.descriptor.getDeclaredProperty(propertyName);
    }

    public ObjEntity getEntity() {
        this.checkDescriptorInitialized();
        return this.descriptor.getEntity();
    }

    public Class getObjectClass() {
        this.checkDescriptorInitialized();
        return this.descriptor.getObjectClass();
    }

    public Iterator getProperties() {
        this.checkDescriptorInitialized();
        return this.descriptor.getProperties();
    }

    public Iterator getIdProperties() {
        this.checkDescriptorInitialized();
        return this.descriptor.getIdProperties();
    }

    public Iterator getMapArcProperties() {
        this.checkDescriptorInitialized();
        return this.descriptor.getMapArcProperties();
    }

    public Property getProperty(String propertyName) {
        this.checkDescriptorInitialized();
        return this.descriptor.getProperty(propertyName);
    }

    public ClassDescriptor getSubclassDescriptor(Class objectClass) {
        this.checkDescriptorInitialized();
        return this.descriptor.getSubclassDescriptor(objectClass);
    }

    public ClassDescriptor getSuperclassDescriptor() {
        this.checkDescriptorInitialized();
        return this.descriptor.getSuperclassDescriptor();
    }

    public void injectValueHolders(Object object) throws PropertyException {
        this.checkDescriptorInitialized();
        this.descriptor.injectValueHolders(object);
    }

    public boolean isFault(Object object) {
        this.checkDescriptorInitialized();
        return this.descriptor.isFault(object);
    }

    public void shallowMerge(Object from, Object to) throws PropertyException {
        this.checkDescriptorInitialized();
        this.descriptor.shallowMerge(from, to);
    }

    public boolean visitDeclaredProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitDeclaredProperties(visitor);
    }

    public boolean visitProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitProperties(visitor);
    }

    public boolean visitAllProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitAllProperties(visitor);
    }
}

