/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.commons.collections.Factory;

public abstract class BatchQuery
implements Query {
    protected int batchIndex;
    protected DbEntity dbEntity;
    protected String name;

    public BatchQuery(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
        this.batchIndex = -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new DefaultQueryMetadata(){

            public DbEntity getDbEntity() {
                return BatchQuery.this.dbEntity;
            }
        };
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        router.route(router.engineForDataMap(this.dbEntity.getDataMap()), this, substitutedQuery);
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.batchAction(this);
    }

    public boolean isUsingOptimisticLocking() {
        return false;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract List getDbAttributes();

    public void reset() {
        this.batchIndex = -1;
    }

    public boolean next() {
        ++this.batchIndex;
        return this.size() > this.batchIndex;
    }

    public abstract Object getValue(int var1);

    public abstract int size();

    protected Object getValue(Map valueMap, DbAttribute attribute) {
        Object value = valueMap.get(attribute.getName());
        if (value instanceof Factory) {
            value = ((Factory)value).create();
            if (attribute.isPrimaryKey()) {
                if (value == null) {
                    String name = attribute.getEntity() != null ? attribute.getEntity().getName() : "<null>";
                    throw new CayenneRuntimeException("Failed to generate PK: " + name + "." + attribute.getName());
                }
                ObjectId id = this.getObjectId();
                if (id != null) {
                    id.getReplacementIdMap().put(attribute.getName(), value);
                }
            }
            valueMap.put(attribute.getName(), value);
        }
        return value;
    }

    public ObjectId getObjectId() {
        return null;
    }
}

