/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import java.util.Iterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class ObjEntityValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        ObjEntity ent = (ObjEntity)path.getObject();
        this.validateName(ent, path, validator);
        this.validateClassName(ent, path, validator);
        this.validateSuperClassName(ent, path, validator);
        if (ent.getDbEntity() == null) {
            validator.registerWarning("ObjEntity has no DbEntity mapping.", path);
        }
    }

    private void validateClassName(ObjEntity ent, ProjectPath path, Validator validator) {
        String className = ent.getClassName();
        if (Util.isEmptyString(className)) {
            return;
        }
        MappingNamesHelper helper = MappingNamesHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(className);
        if (invalidChars != null) {
            validator.registerWarning("ObjEntity Java class contains invalid characters: " + invalidChars, path);
        } else if (helper.invalidDataObjectClass(className)) {
            validator.registerWarning("ObjEntity Java class is invalid: " + className, path);
        } else if (className.indexOf(46) < 0) {
            validator.registerWarning("Placing Java class in default package is discouraged: " + className, path);
        }
    }

    private void validateSuperClassName(ObjEntity ent, ProjectPath path, Validator validator) {
        String superClassName = ent.getSuperClassName();
        if (Util.isEmptyString(superClassName)) {
            return;
        }
        MappingNamesHelper helper = MappingNamesHelper.getInstance();
        String invalidChars = helper.invalidCharsInJavaClassName(superClassName);
        if (invalidChars != null) {
            validator.registerWarning("ObjEntity Java superclass contains invalid characters: " + invalidChars, path);
        } else if (helper.invalidDataObjectClass(superClassName)) {
            validator.registerWarning("ObjEntity Java superclass is invalid: " + superClassName, path);
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
    }

    protected void validateName(ObjEntity entity, ProjectPath path, Validator validator) {
        DataDomain domain;
        String name = entity.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed ObjEntity.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        Iterator it = map.getObjEntities().iterator();
        while (it.hasNext()) {
            ObjEntity otherEnt = (ObjEntity)it.next();
            if (otherEnt == entity || !name.equals(otherEnt.getName())) continue;
            validator.registerError("Duplicate ObjEntity name: " + name + ".", path);
            break;
        }
        if ((domain = (DataDomain)path.firstInstanceOf(DataDomain.class)) != null) {
            Iterator maps = domain.getDataMaps().iterator();
            while (maps.hasNext()) {
                ObjEntity conflictingEntity;
                DataMap nextMap = (DataMap)maps.next();
                if (nextMap == map || (conflictingEntity = nextMap.getObjEntity(name)) == null || Util.nullSafeEquals(conflictingEntity.getClassName(), entity.getClassName())) continue;
                validator.registerWarning("Duplicate ObjEntity name in another DataMap: " + name + ".", path);
                break;
            }
        }
    }
}

