/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.FileConfiguration;
import org.apache.cayenne.project.ProjectDataSourceFactory;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.util.ResourceLocator;

public class ProjectConfiguration
extends FileConfiguration {
    public ProjectConfiguration(File projectFile) {
        super(projectFile);
        this.setIgnoringLoadFailures(true);
        ResourceLocator locator = this.getResourceLocator();
        locator.setSkipAbsolutePath(false);
        locator.setSkipClasspath(true);
        locator.setSkipCurrentDirectory(true);
        locator.setSkipHomeDirectory(true);
    }

    public boolean canInitialize() {
        return super.canInitialize() && this.getProjectFile().isFile();
    }

    protected void setProjectFile(File projectFile) {
        if (projectFile != null && projectFile.exists()) {
            super.setProjectFile(projectFile);
        } else {
            this.projectFile = projectFile;
            this.setDomainConfigurationName("cayenne.xml");
        }
    }

    public DataSourceFactory getDataSourceFactory() {
        try {
            return new ProjectDataSourceFactory(this.getProjectDirectory());
        }
        catch (Exception e) {
            throw new ProjectException("Error creating DataSourceFactory.", e);
        }
    }
}

