/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.reflect;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.jpa.reflect.JpaCollectionFieldAccessor;
import org.apache.cayenne.jpa.reflect.JpaListProperty;
import org.apache.cayenne.jpa.reflect.JpaMapProperty;
import org.apache.cayenne.jpa.reflect.JpaSetProperty;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.FaultFactory;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.pojo.EnhancedPojoDescriptorFactory;

public class JpaClassDescriptorFactory
extends EnhancedPojoDescriptorFactory {
    public JpaClassDescriptorFactory(ClassDescriptorMap descriptorMap, FaultFactory faultFactory) {
        super(descriptorMap, faultFactory);
    }

    protected void createToManyListProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), List.class);
        JpaListProperty property = new JpaListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    protected void createToManyMapProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Map.class);
        Accessor mapKeyAccessor = this.createMapKeyAccessor(relationship, targetDescriptor);
        JpaMapProperty property = new JpaMapProperty(descriptor, targetDescriptor, accessor, reverseName, mapKeyAccessor);
        descriptor.addDeclaredProperty(property);
    }

    protected void createToManySetProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Set.class);
        JpaSetProperty property = new JpaSetProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    protected void createToManyCollectionProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Collection.class);
        JpaListProperty property = new JpaListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }
}

