/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;

public class JpaPropertyDescriptor {
    protected AnnotatedElement member;
    protected String name;
    protected Class type;
    protected Type genericType;
    protected Class targetEntityType;

    public JpaPropertyDescriptor(Field field) {
        this.member = field;
        this.name = field.getName();
        this.type = field.getType();
        this.initTargetEntityType(field.getGenericType());
    }

    public JpaPropertyDescriptor(Method getter, String name) {
        if (JpaClassDescriptor.propertyNameForGetter(getter.getName()) == null) {
            throw new JpaProviderException("Invalid property getter name: " + getter.getName());
        }
        this.member = getter;
        this.name = name;
        this.type = getter.getReturnType();
        this.initTargetEntityType(getter.getGenericReturnType());
    }

    protected void initTargetEntityType(Type genericType) {
        this.targetEntityType = Void.TYPE;
        if (Collection.class.isAssignableFrom(this.type)) {
            ParameterizedType pType;
            Type[] types;
            if (genericType instanceof ParameterizedType && (types = (pType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && types[0] instanceof Class) {
                this.targetEntityType = (Class)types[0];
                return;
            }
        } else if (Map.class.isAssignableFrom(this.type)) {
            ParameterizedType pType;
            Type[] types;
            if (genericType instanceof ParameterizedType && (types = (pType = (ParameterizedType)genericType).getActualTypeArguments()).length == 2 && types[1] instanceof Class) {
                this.targetEntityType = (Class)types[1];
                return;
            }
        } else {
            this.targetEntityType = this.type;
        }
    }

    public AnnotatedElement getMember() {
        return this.member;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Class getTargetEntityType() {
        return Void.TYPE.equals(this.targetEntityType) ? null : this.targetEntityType;
    }

    public boolean isStringType() {
        return String.class.isAssignableFrom(this.type);
    }

    public boolean isDefaultNonRelationalType() {
        return this.isDefaultNonRelationalType(this.getTargetEntityType());
    }

    boolean isDefaultNonRelationalType(Class type) {
        if (type.isPrimitive() || type.isEnum()) {
            return true;
        }
        if (type.isArray()) {
            return this.isDefaultNonRelationalType(type.getComponentType());
        }
        return Serializable.class.isAssignableFrom(type);
    }
}

